package com.ericsson.cms.sites.ui.client;

import java.util.Map;

import com.ericsson.cms.sites.ui.client.SitesTabContainer.SiteCRUDNotifier;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class RulesTab extends Composite implements ISiteTab {
	
	private static final int MAIN_PANEL_OFFSET_HEIGHT = 250;

	private UISite site;
	
	private VerticalContainer mainPanel;
	private ScrollContainer scrollPanel;
	private SitesRuleListingPanel validationRuleSetsPanel;
	private SitesRuleListingPanel normalizationRuleSetsPanel;
	private SitesRuleListingPanel processingRuleSetsPanel;
	private SitesRuleListingPanel targetingRuleSetsPanel;
	private SitesRuleListingPanel prioritizationRuleSetsPanel;

	private MessageArea messageArea;

	private SitesConstants constants = GWT.create(SitesConstants.class);

	private HandlerRegistration windowRegistration = null;

	public RulesTab() {
		mainPanel = new VerticalContainer();
		mainPanel.setSpacing(10);

		scrollPanel = new ScrollContainer();
		scrollPanel.add(mainPanel);

		validationRuleSetsPanel = new SitesRuleListingPanel(Packages.VALIDATION);
		mainPanel.add(validationRuleSetsPanel);
		
		normalizationRuleSetsPanel = new SitesRuleListingPanel(Packages.NORMALIZATION);
		mainPanel.add(normalizationRuleSetsPanel);
		
		processingRuleSetsPanel = new SitesRuleListingPanel(Packages.PROCESSING);
		mainPanel.add(processingRuleSetsPanel);
		
		targetingRuleSetsPanel = new SitesRuleListingPanel(Packages.TARGETING);
		mainPanel.add(targetingRuleSetsPanel);

		prioritizationRuleSetsPanel = new SitesRuleListingPanel(Packages.PRIORITIZATION);
		mainPanel.add(prioritizationRuleSetsPanel);

		initWidget(scrollPanel);

		Scheduler.get().scheduleDeferred(new ScheduledCommand() {
			@Override
			public void execute() {
				updateMainPanelSize();
			}
		});
	}
	
	@Override
	public String getName() {
		return "Rules";
	}

	@Override
	public String getDisplayName() {
		return constants.rulesTabName();
	}

	@Override
	public void setCRUDNotifier(SiteCRUDNotifier crudNotifier) {}

	@Override
	public boolean setSite(UISite site, Map<String, String> params) {
		this.site = site;
		return (site != null && site.getType() != UISiteType.TRACKING);
	}

	@Override
	public void setSelected(boolean selected) {
		if(selected && site!= null) {
			History.newItem(Anchors.getAnchor(site.getId(), site.getParentId(), getName()), false);
			validationRuleSetsPanel.setSite(site.getId());
			normalizationRuleSetsPanel.setSite(site.getId());
			processingRuleSetsPanel.setSite(site.getId());
			targetingRuleSetsPanel.setSite(site.getId());
			prioritizationRuleSetsPanel.setSite(site.getId());
		}

		messageArea.reset();
	}

	@Override
	public void setMessageArea(MessageArea messageArea) {
		this.messageArea = messageArea;
	}

	@Override
	protected void onLoad() {
		super.onLoad();

		windowRegistration = Window.addResizeHandler(new ResizeHandler() {
			public void onResize(ResizeEvent event) {
				updateMainPanelSize();
			}
		});
	};

	@Override
	protected void onUnload() {
		windowRegistration.removeHandler();
		windowRegistration = null;

		super.onUnload();
	}

	protected void updateMainPanelSize() {
		int offsetHeight = MAIN_PANEL_OFFSET_HEIGHT;
		
		scrollPanel.setHeight(Window.getClientHeight() - offsetHeight + "px");
	}

}
