package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.scheduling.ui.client.Action;
import com.ericsson.cms.scheduling.ui.client.IUISchedulerClient;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

public class SiteTimerUISchedulerClient implements IUISchedulerClient {

	private NeptuneSecurity security;

	public SiteTimerUISchedulerClient(NeptuneSecurity security) {
		this.security = security;
	}

	@Override
	public String getName() {
		return "sitetimer";
	}

	@Override
	public boolean isUserAuthorized(Action action) {
		switch(action) {
		case VIEW:
		case CREATE:
		case ACTIVATE:
		case INACTIVATE:
		case DELETE:
		case MODIFY:
		case EXECUTE:
			return false;
		case ENABLE_EXECUTION:
		case DISABLE_EXECUTION:
			return security.isUserInRole(Permissions.EDIT);
		default:
			return true;
		}
	}

}
