package com.ericsson.cms.sites.ui.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.scheduling.ui.client.IUISchedulerClient;
import com.ericsson.cms.sites.ui.client.activity.SitesActivityWidgetFactory;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.portlet.DistributionPortlet;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;

public class SitesComponent extends ComponentBase {

	private Map<String, String> info;
	private SitesConstants constants = GWT.create(SitesConstants.class);
	
	@Override
	public void init(EventListenerRegistry eventListenerRegistry,
			EventSink eventSink, ServiceLoader serviceLoader,
			Map<String, String> info) {
		super.init(eventListenerRegistry, eventSink, serviceLoader, info);
		this.info = info;
	}

	@Override
	public List<PortletFactory> listPortlets(NeptuneSecurity security) {

		if(!security.isUserInRole(Permissions.VIEW))
			return null;
		
		List<PortletFactory> portlets = new ArrayList<PortletFactory>();
		
		if (security.isUserInRole(Permissions.VIEW)) {
			Portlet distPortlet = new DistributionPortlet(security, info);
			portlets.add(new SitePortletFactory(distPortlet, this));
		}

		return portlets;
	}

	@Override
	@SuppressWarnings("unchecked")
	public <E extends Service> List<E> listServices(Class<E> clazz,
			NeptuneSecurity security) {
		List<E> services = new ArrayList<E>();
		if(clazz.equals(IUISchedulerClient.class)) {
			services.add((E) new SitesUISchedulerClient(security));
			services.add((E) new SiteTimerUISchedulerClient(security));
			services.add((E) new DistScheduleUISchedulerClient(security));
		}
		return services;
	}

	@Override
	public List<MenuItemBase> listTabs(final NeptuneSecurity security) {
		List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();

		/* Always add the group menu item */
		List<MenuItemBase> childMenuItems = new ArrayList<MenuItemBase>();
		GroupMenuItem rootMenuItem = new GroupMenuItem("Sites", childMenuItems);
		tabs.add(rootMenuItem);

		if (security.isUserInRole(Permissions.VIEW)) {
			SitesViewWidgetFactory factory = new SitesViewWidgetFactory(info);
			WidgetMenuItem viewMenuItem = new WidgetMenuItem("View", factory, factory.getAnchorChangeListener());
			childMenuItems.add(viewMenuItem);
			
			MSOAdminWidgetFactory msoFactory = new MSOAdminWidgetFactory(info);
			WidgetMenuItem msoMenuItem = new WidgetMenuItem("MSO", msoFactory, msoFactory.getAnchorChangeListener());
			childMenuItems.add(msoMenuItem);
		
			SitesActivityWidgetFactory activityFactory = new SitesActivityWidgetFactory(info);
			WidgetMenuItem activityMenuItem =
				new WidgetMenuItem("Activity", activityFactory, activityFactory.getAnchorChangeListener());
			childMenuItems.add(activityMenuItem);
		}
		
		return tabs;
	}

	/*
	 * Portlet Factory that maintains the single portlet instance created
	 */
	private static final class SitePortletFactory implements PortletFactory {
		private final Portlet portlet;
		private final SitesComponent sitesComponent;

		public SitePortletFactory(Portlet portlet, SitesComponent sitesComponent) {
			this.portlet = portlet;
			this.sitesComponent = sitesComponent;
		}

		@Override
		public Portlet getInstance() {
			return this.portlet;
		}

		@Override
		public void release(Portlet widget) {
		}

                @Override
                public Component getComponent() {
                    return sitesComponent;
                }
	}

    @Override
    public String getName() {
        return "SITES";
    }

    @Override
    public String getDisplayName() {
        return constants.componentDisplayName();
    }
}
