package com.ericsson.cms.sites.ui.client;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.sites.ui.client.UiRuleSetsAssocWJobExpception.UiRuleSetJobsAssoc;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.RulesListingPanelBase;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleListItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class SitesRuleListingPanel extends RulesListingPanelBase {
	private Integer siteId;
	
	private IUISiteServiceAsync service = GWT.create(IUISiteService.class);
	private SitesConstants sitesConstants;
	
	public SitesRuleListingPanel(Packages packages) {
		super(packages, false);
		refreshTable();
	}
	
	public void setSite(Integer siteId) {
		this.siteId = siteId;
		refreshTable();
	}

	protected void createAndAddButtons() {
		createSitesConstants();
		// add buttons depending on security
		NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
		// user can create rulesets for a site only if he has site modify and rule create permissions
		if (security.isUserInRole(Permissions.CREATE) && security.isUserInRole(com.ericsson.cms.sites.ui.client.Permissions.EDIT)) {
			addButton(constants.createRuleSetButtonLabel(), StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE, new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					RulesComponent.getInstance().setNewRuleAnchor(pkgType, siteId);
				}
			});
		}
		// user can dissociate rulesets only if he has permissions to modify the site and rulesets both
		if (security.isUserInRole(Permissions.MODIFY) && security.isUserInRole(com.ericsson.cms.sites.ui.client.Permissions.EDIT)) {
			addButton(sitesConstants.buttonLabelDissociate(), StyleNames.DATALOSS_BUTTON_STYLE, new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					busyIndicator.center();
					service.dissociateRuleSets(siteId, table.getSelectedIds(), new NeptuneAsyncCallback<Void>() {
						@Override
						public void onNeptuneFailure(Throwable caught) {
							busyIndicator.hide();
							SitesMessages sitesMessages = GWT.create(SitesMessages.class);
							if(caught instanceof UiRuleSetsNotAssocWSiteExpception) {
								UiRuleSetsNotAssocWSiteExpception e = (UiRuleSetsNotAssocWSiteExpception) caught;
								String msg = sitesMessages.dissociateFail(e.getRuleSets());
								setErrorMessage(msg);
							} else if(caught instanceof UiRuleSetsAssocWJobExpception) { 
								UiRuleSetsAssocWJobExpception e = (UiRuleSetsAssocWJobExpception) caught;
								List<UiRuleSetJobsAssoc> issues = e.getIssues();

								List<String> errMsgs = new ArrayList<String>();
								
								// go thru each reason (one per rulset)
								for(UiRuleSetJobsAssoc issue : issues) {
									String rsId = issue.getRuleSetId();
									String jobNames = issue.getJobNames();
									String msg = sitesMessages.dissociateFailDueToJobs(rsId, jobNames);
									errMsgs.add(msg);
								}
								
								setErrorMessages(errMsgs);

							} else {
								setErrorMessage(sitesConstants.dissociatingRuleSetsFailed());
							}
						}

						@Override
						public void onNeptuneSuccess(Void result) {
							refreshTable();
							setInfoMessage(sitesConstants.dissociatingRuleSetsSucceeded());
							busyIndicator.hide();
						}});
				}});
		}
	}

	@Override
	protected void refreshTable() {
		createSitesConstants();
		messageArea.reset();
		table.clear();
		if(siteId == null) {
			busyIndicator.hide();
			return;
		}
		busyIndicator.center();
		service.getRuleSetsBySiteAndPackage(siteId, pkgType, new NeptuneAsyncCallback<List<UIRuleListItem>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				setErrorMessage(sitesConstants.loadingRuleSetsFailed());
				busyIndicator.hide();
			}

			@Override
			public void onNeptuneSuccess(List<UIRuleListItem> result) {
				populateTable(table, result);
				busyIndicator.hide();
			}});
	}
	
	private void createSitesConstants() {
		if(sitesConstants == null)
			sitesConstants = GWT.create(SitesConstants.class);
	}
}
