/**
 * File Name	:	SitesTreeButtonsPanel.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jun 15, 2012 5:32:30 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.sites.ui.client.entities.UISiteTreeNode;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class SitesTreeButtonsPanel extends Composite {

	private static final String STYLE_SITES_TREE_BUTTONS_PANEL = "sites-tree-buttons-panel";

	private Button createButton;
	private FlowPanel buttonsPanel;

	private SitesTabContainer detailView; 
	
	private NeptuneSecurity security;

	private SitesConstants constants = GWT.create(SitesConstants.class);

	/**
	 * 
	 */
	public SitesTreeButtonsPanel(final NeptuneSecurity security) {
		super();
		
		this.security = security;
		buttonsPanel = new FlowPanel();
		buttonsPanel.setStyleName(STYLE_SITES_TREE_BUTTONS_PANEL);
		
		createButton = new Button(constants.buttonLabelCreate());
		buttonsPanel.add(createButton);
		createButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		createButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {
				final CreateSiteDialogBox createSiteDialogBox = new CreateSiteDialogBox(security, true, true, detailView);
				createSiteDialogBox.setPopupPositionAndShow(new PopupPanel.PositionCallback() {
			          public void setPosition(int offsetWidth, int offsetHeight) {
							Button source =  (Button) event.getSource();
							int left = source.getAbsoluteLeft() + source.getOffsetWidth();
							int top = source.getAbsoluteTop() - offsetHeight;
							createSiteDialogBox.setPopupPosition(left, top);
			          }
				});
			}
			
		});
				
		initWidget(buttonsPanel);

		reset();
	}

	/**
	 * @param siteInfo the siteInfo to set
	 */
	public void setSiteInfo(UISiteTreeNode siteInfo) {
		configureButtons(security, siteInfo);
	}
	
	private void configureButtons(NeptuneSecurity security, UISiteTreeNode siteInfo) {	
		reset();			
	}

	public void reset() {
		createButton.setEnabled(security.isUserInRole(Permissions.CREATE));
	}

	public void setDetailView(SitesTabContainer detailView) {
		this.detailView = detailView;
	}
}
