package com.ericsson.cms.sites.ui.client;

import com.ericsson.cms.scheduling.ui.client.Action;
import com.ericsson.cms.scheduling.ui.client.IUISchedulerClient;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

public class SitesUISchedulerClient implements IUISchedulerClient {

	private NeptuneSecurity security;

	public SitesUISchedulerClient(NeptuneSecurity security) {
		this.security = security;
	}

	@Override
	public String getName() {
		return "Sites";
	}

	@Override
	public boolean isUserAuthorized(Action action) {
		switch(action) {
		case VIEW:
			return security.isUserInRole(Permissions.VIEW);
		case CREATE:
		case ACTIVATE:
		case INACTIVATE:
		case ENABLE_EXECUTION:
		case DISABLE_EXECUTION:
		case DELETE:
			return security.isUserInRole(Permissions.EDIT);
		case MODIFY:
		case EXECUTE:
		default:
			return true;
		}
	}

}
