package com.ericsson.cms.sites.ui.client;

import java.util.Map;

import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

/**
 * Contains Sites Tree and Site Details Panel in a horizontal panel layout.
 * <p>
 * Sites Tree has a buttons panel associated (for site tree operations
 * which were earlier available in right context menu only) which is situated 
 * in the south of a {@link com.google.gwt.user.client.ui.DockPanel). Sites Tree itself
 * is situated in the center of that {@link com.google.gwt.user.client.ui.DockPanel}.
 * 
 * @author Raj Prakash
 */
public class SitesViewPanel extends Composite implements AnchorChangeListener {
	private static final String STYLE_SITES_TREE_DOCK_PANEL = "sites-tree-dock-panel";
	private static final String STYLE_SITES_TABCONTAINER_DOCK_PANEL = "sites-tabContainer-dock-panel";

	private static final int CMS_MENU_HEADER_HEIGHT = 178;
	private static final int SITES_TREE_WIDTH = 193;
	
	private HeaderPanel breadCrumbsPanel;
	private SitesTree treeWidget;
	private SitesTabContainer sitesTabContainer;
	private SitesTreeButtonsPanel buttonsPanel;
	private DockPanel leftDockPanel;
	private VerticalPanel sitesTreeContainer;
	private ScrollPanel sitesTreeScrollPanel;
	private VerticalPanel sitesListPanel;
	private DockPanel rightDockPanel;
	private MessageArea messageArea;
	
	private HandlerRegistration windowRegistration = null;
	private ScheduledCommand resizeCommand;
	
	private SitesConstants constants = GWT.create(SitesConstants.class);

	public SitesViewPanel(NeptuneSecurity security, Map<String, String> info) {
		VerticalPanel mainPanel = new VerticalPanel();
		mainPanel.setSpacing(10);
		breadCrumbsPanel = new HeaderPanel(constants.breadCrumbsViewSites());
		mainPanel.add(breadCrumbsPanel);
		HorizontalContainer horizontalPanel = new HorizontalContainer();
		mainPanel.add(horizontalPanel);
		horizontalPanel.setWidth("100%");
		horizontalPanel.setHeight("100%");
		
		treeWidget = new SitesTree(security);
		sitesTreeContainer = new VerticalPanel();
		sitesTreeContainer.add(treeWidget);
		sitesTreeScrollPanel = new ScrollPanel();
		sitesTreeScrollPanel.add(sitesTreeContainer);
		buttonsPanel = new SitesTreeButtonsPanel(security);
		leftDockPanel = new DockPanel();
	    leftDockPanel.add(buttonsPanel, DockPanel.SOUTH);
	    leftDockPanel.add(sitesTreeScrollPanel, DockPanel.CENTER);
	    leftDockPanel.setStyleName(STYLE_SITES_TREE_DOCK_PANEL);
	    
	    horizontalPanel.add(leftDockPanel);
		horizontalPanel.setCellHorizontalAlignment(leftDockPanel, HorizontalContainer.ALIGN_LEFT);
		horizontalPanel.setCellWidth(leftDockPanel, "200px");

		Panel messagePanel = new VerticalPanel();
		messageArea = new MessageArea();
		messagePanel.add(messageArea);
		
		sitesTabContainer = new SitesTabContainer(treeWidget, messageArea, info);
		rightDockPanel = new DockPanel();
	    rightDockPanel.add(messagePanel, DockPanel.NORTH);
	    rightDockPanel.add(sitesTabContainer, DockPanel.CENTER);
	    rightDockPanel.setStyleName(STYLE_SITES_TABCONTAINER_DOCK_PANEL);
	    horizontalPanel.add(rightDockPanel);
		horizontalPanel.setCellHorizontalAlignment(rightDockPanel, HorizontalContainer.ALIGN_LEFT);
		
		treeWidget.setDetailView(sitesTabContainer);
		treeWidget.setButtonsPanel(buttonsPanel);
		buttonsPanel.setDetailView(sitesTabContainer);
		
		initWidget(mainPanel);

		resizeCommand = new ScheduledCommand() {
			@Override
			public void execute() {
				resizeSitesTreeScrollPanel();
			}
		};
		updateSitesTreeScrollPanelSize();
	}

	@Override
	public void anchorChanged(String anchor) {
		sitesTabContainer.anchorChanged(anchor);
	}
	
	protected void updateSitesTreeScrollPanelSize() {
		Scheduler.get().scheduleDeferred(resizeCommand);
	}
	
	/*
	 * Resize the right scroll panel
	 */
	protected void resizeSitesTreeScrollPanel() {
		/* Calculate the size to use */
		int treeWidth = SITES_TREE_WIDTH;
		int treeHeight = Window.getClientHeight() - CMS_MENU_HEADER_HEIGHT;
		treeHeight -= breadCrumbsPanel.getOffsetHeight();
		treeHeight -= buttonsPanel.getOffsetHeight();

		/* Set the dimensions */
		treeWidget.setPixelSize(treeWidth, treeHeight);
		sitesTabContainer.setPixelSize(Window.getClientWidth() - treeWidth - 100, treeHeight + buttonsPanel.getOffsetHeight() - 100);
	}

	// ==============================================================
	// ===================== WIDGET OVERRIDES
	// ==============================================================

	@Override
	protected void onLoad() {
		super.onLoad();

		windowRegistration = Window.addResizeHandler(new ResizeHandler() {
			public void onResize(ResizeEvent event) {
				updateSitesTreeScrollPanelSize();
			}
		});
	};

	@Override
	protected void onUnload() {
		windowRegistration.removeHandler();
		windowRegistration = null;

		super.onUnload();
	}

}
