/**
 * File Name	:	StatusPluginPanel.java
 * Created		: 	Apr 23, 2010 3:45:58 PM
 * Created By	: 	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Purpose		:	
 *
 * (c) 2010 Ericsson Television Inc.
 */
package com.ericsson.cms.sites.ui.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.sites.ui.client.entities.UIStatusPlugin;
import com.ericsson.cms.sites.ui.client.images.ISiteClientBundle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author esakhat
 * 
 */
public class StatusPluginPanel extends Composite implements ChangeHandler {

	public static final int DEFAULT_PROPERTY_VALUE_TEXT_BOX_LENGTH = 10;
	public static final int DEFAULT_PROPERTY_VALUE_TEXT_BOX_LENGTH_EXCESS = 5;
	public static final String DEFAULT_PROPERTY_VALUE_NULL_STRING = "";
	
	private VerticalContainer container;
	private HorizontalContainer listBoxContainer;
	private ListBoxWidget<UIStatusPlugin> listBox;
	private FlexTable propsTable;
	private ImageWidget isNotLoadedImage;
	private ISiteClientBundle clientBundle = GWT.create(ISiteClientBundle.class);
	
	private UIStatusPlugin associatedPlugin;
	private List<UIStatusPlugin> availablePlugins = new ArrayList<UIStatusPlugin>();

	public StatusPluginPanel() {
		container = new VerticalContainer();
		initWidget(container);

		container.setBorderWidth(1);
		
		listBoxContainer = new HorizontalContainer();
		listBoxContainer.setSpacing(1);
		isNotLoadedImage = new ImageWidget();
		isNotLoadedImage.setResource(clientBundle.sitePluginConfigurationError());
		isNotLoadedImage.setVisible(false);
		listBoxContainer.add(isNotLoadedImage);
		listBox = new ListBoxWidget<UIStatusPlugin>();
		listBox.addChangeHandler(this);
		listBoxContainer.add(listBox);
		container.add(listBoxContainer);

		propsTable = new FlexTable();
		container.add(propsTable);
	}

	public void setAssociatedPlugin(UIStatusPlugin uiStatusPlugin) {
		associatedPlugin = uiStatusPlugin;
		displayAssociatedPlugin();
	}

	public UIStatusPlugin getAssociatedPlugin() {
		return associatedPlugin;
	}

	public void setAvailablePlugins(List<UIStatusPlugin> availablePlugins) {
		if (availablePlugins != null) {
			this.availablePlugins.clear();
			this.availablePlugins.addAll(availablePlugins);
			
			listBox.clear();
			for (UIStatusPlugin uiStatusPlugin : availablePlugins) {
				addPluginToListBox(uiStatusPlugin);
			}

		}
		
		if (associatedPlugin != null) {
			displayAssociatedPlugin();
		}
		
	}

	private void displayAssociatedPlugin() {
		boolean isAssociatedPluginAvailable = availablePlugins.contains(associatedPlugin);
		if (!isAssociatedPluginAvailable) {
			addPluginToListBox(associatedPlugin);
			isNotLoadedImage.setVisible(true);
		}
		else {
			isNotLoadedImage.setVisible(false);
		}
		listBox.setSelectedItem(associatedPlugin);
		refreshView();
	}
	
	private void refreshView() {
		if (associatedPlugin != null) {
			updatePropsTable(associatedPlugin);
		}
	}
	
	private void updatePropsTable(UIStatusPlugin uiStatusPlugin) {
		if (uiStatusPlugin != null) {
			propsTable.clear(false);
			Map<String, String> props = uiStatusPlugin.getConfiguration();
			int row = 0;
			int column = 0;
			if (props != null) {
				for (String key : props.keySet()) {
					String value = props.get(key);
					value = (value != null) ? value : DEFAULT_PROPERTY_VALUE_NULL_STRING;
					propsTable.setWidget(row, column, new LabelWidget(key));
					column += 1;
					TextBoxWidget valueWidget = new TextBoxWidget();
					int valueLength = value.length();
					int valueTextBoxLength = (valueLength > DEFAULT_PROPERTY_VALUE_TEXT_BOX_LENGTH) ? (valueLength + DEFAULT_PROPERTY_VALUE_TEXT_BOX_LENGTH_EXCESS)
							: DEFAULT_PROPERTY_VALUE_TEXT_BOX_LENGTH;
					valueWidget.setMaxLength(valueTextBoxLength);
					valueWidget.setVisibleLength(valueTextBoxLength);
					valueWidget.setText(value);
					valueWidget.setEnabled(false);
					propsTable.setWidget(row, column, valueWidget);
					column = 0;
					row += 1;
				}
			}
		}
	}
	
	private void addPluginToListBox(UIStatusPlugin uiStatusPlugin) {
		if (uiStatusPlugin != null) {
			String pluginName = uiStatusPlugin.getId();
			Map<String, String> config = uiStatusPlugin.getConfiguration();
			if(config != null) {
				String displayName = config.get("Display Name");
				if(displayName != null && !displayName.trim().isEmpty()) {
					pluginName = displayName;
				}
			}
			listBox.addItem(pluginName, uiStatusPlugin);
		}
	}
	
	public void reset() {
		associatedPlugin = null;
		availablePlugins = new ArrayList<UIStatusPlugin>();
	}
	
	@Override
	public void onChange(ChangeEvent event) {
		associatedPlugin = listBox.getSelectedItem();
		boolean isAssociatedPluginAvailable = availablePlugins.contains(associatedPlugin);
		if (!isAssociatedPluginAvailable) {
			isNotLoadedImage.setVisible(true);
		}
		else {
			isNotLoadedImage.setVisible(false);
		}
		refreshView();		
	}

}
