package com.ericsson.cms.sites.ui.client;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class TrackingSitesListPanel extends Composite {
	private static final String TABLE_STYLE = "sites-trackingSitesList";
	private static final String HEADER_ROW_STYLE = "sites-trackingSitesList-header";
	private static final String DATA_ROW_STYLE = "sites-trackingSitesList-data";
	
	private BusyIndicator busyIndicator = new BusyIndicator(true);
	
	private VerticalContainer mainPanel = new VerticalContainer();
	private FlexTable table = new FlexTable();
	private List<CheckBoxWidget> rowCheckBoxes;
	
	private int distributionSiteId;
	private AsyncCallback<Void> callback;
	private Set<Integer> selectedIds = new HashSet<Integer>();
	
	private IUISiteServiceAsync service = GWT.create(IUISiteService.class);
	private SitesConstants constants = GWT.create(SitesConstants.class);

	public TrackingSitesListPanel(int distributionSiteId, AsyncCallback<Void> callback) {
		this.distributionSiteId = distributionSiteId;
		this.callback = callback;
		table.addStyleName(TABLE_STYLE);
		mainPanel.add(table);
		ButtonWidget addButton = new ButtonWidget(constants.buttonLabelAdd());
		addButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		addButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				addTrackingSites();
			}});
		mainPanel.add(addButton);
		load();
		initWidget(mainPanel);
	}

	private void load() {
		busyIndicator.center();
		service.getShareableTrackingSites(distributionSiteId, new NeptuneAsyncCallback<List<UISite>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				busyIndicator.hide();
				Window.alert(constants.loadingTrackingSitesFailed() + " | "
						+ (caught == null ? "" : caught.getLocalizedMessage()));
			}

			@Override
			public void onNeptuneSuccess(List<UISite> trackingSites) {
				buildTable(trackingSites);
				busyIndicator.hide();
			}
		});
	}
	
	private void buildTable(List<UISite> trackingSites) {
		table.getRowFormatter().addStyleName(0, HEADER_ROW_STYLE);
		final CheckBoxWidget allCB = new CheckBoxWidget();
		allCB.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
			@Override
			public void onValueChange(ValueChangeEvent<Boolean> event) {
				if(rowCheckBoxes != null) {
					for(CheckBoxWidget cb : rowCheckBoxes) {
						cb.setValue(event.getValue(), true);
					}
				}
			}});
		table.setWidget(0, 0, allCB);
		table.setWidget(0, 1, new LabelWidget(constants.fieldLabelName()));
		table.setWidget(0, 2, new LabelWidget(constants.fieldLabelExternalId()));
		table.setWidget(0, 3, new LabelWidget(constants.fieldLabelDescription()));
		
		rowCheckBoxes = new ArrayList<CheckBoxWidget>(trackingSites.size());
		int rowIndex = 1;
		for(final UISite ts : trackingSites) {
			table.getRowFormatter().addStyleName(rowIndex, DATA_ROW_STYLE);
			CheckBoxWidget cb = new CheckBoxWidget();
			cb.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
				@Override
				public void onValueChange(ValueChangeEvent<Boolean> event) {
					if(event.getValue()) {
						selectedIds.add(ts.getId());
					} else {
						allCB.setValue(false, false);
						selectedIds.remove(ts.getId());
					}
				}});
			table.setWidget(rowIndex, 0, cb);
			table.setWidget(rowIndex, 1, new LabelWidget(ts.getName()));
			table.setWidget(rowIndex, 2, new LabelWidget(ts.getExternalId()));
			table.setWidget(rowIndex, 3, new LabelWidget(ts.getDescription()));
			rowCheckBoxes.add(cb);
			rowIndex++;
		}
	}
	
	private void addTrackingSites() {
		if(selectedIds.isEmpty())
			return;
		
		busyIndicator.center();
		service.associateTrackingSites(selectedIds, distributionSiteId, new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				busyIndicator.hide();
				Window.alert(constants.sharingTrackingSitesFailed() + " | "
						+ (caught == null ? "" : caught.getLocalizedMessage()));
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				busyIndicator.hide();
				callback.onSuccess(null);
			}});
	}
	
	@Override
	protected void onUnload() {
		super.onUnload();
		busyIndicator.hide();
	}
}
