package com.ericsson.cms.sites.ui.client;

import java.io.Serializable;
import java.util.List;

import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

public class UiRuleSetsAssocWJobExpception extends NeptuneException {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private List<UiRuleSetJobsAssoc> issues;

	public UiRuleSetsAssocWJobExpception() {
		super();
	}

	public UiRuleSetsAssocWJobExpception(List<UiRuleSetJobsAssoc> issues) {
		this();
		setIssues(issues);
	}

	public void setIssues(List<UiRuleSetJobsAssoc> issues) {
		this.issues = issues;
	}

	public List<UiRuleSetJobsAssoc> getIssues() {
		return issues;
	}

	public static class UiRuleSetJobsAssoc implements Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
		private String ruleSetId;
		private String jobNames;
		
		public UiRuleSetJobsAssoc() {
			this("", "");
		}

		public UiRuleSetJobsAssoc(String ruleSetId, String jobNames) {
			super();
			this.ruleSetId = ruleSetId;
			this.jobNames = jobNames;
		}

		public String getRuleSetId() {
			return ruleSetId;
		}

		public void setRuleSetId(String ruleSetId) {
			this.ruleSetId = ruleSetId;
		}

		public String getJobNames() {
			return jobNames;
		}

		public void setJobNames(String jobNames) {
			this.jobNames = jobNames;
		}

	}
}
