package com.ericsson.cms.sites.ui.client.activity;

import java.util.List;

import com.ericsson.cms.sites.ui.client.IUISiteService;
import com.ericsson.cms.sites.ui.client.IUISiteServiceAsync;
import com.ericsson.cms.sites.ui.client.entities.SiteActivityTable;
import com.ericsson.cms.sites.ui.client.entities.SiteActivityTables;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.entities.SiteActivityTable.Column;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.InlineLabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class SitesActivityResultsPanel extends Composite {
	private static final String DIST_SITES_TAB_NAME = "Distribution Sites";
	private static final String TRACK_SITES_TAB_NAME = "Tracking Sites";
	
	private static final String TABLE_STYLE = "sitesActivity-resultsTable";
	private static final String HEADER_ROW_STYLE = "sitesActivity-resultsTable-header";
	private static final String HEADER_TEXT_STYLE = "sitesActivity-resultsTable-header-text";
	private static final String DATA_ROW_STYLE = "sitesActivity-resultsTable-data";
	private static final String SITE_NAME_STYLE = "sitesActivity-resultsTable-siteName";
	
	private VerticalContainer mainContainer;
	private MessageArea messageArea;
	private HeaderPanel header;
	private ResizableContainer resizableContainer;
	private VerticalContainer distTablesContainer, trackTablesContainer;
	private BusyIndicator busyIndicator = new BusyIndicator();
	
	private IUISiteServiceAsync service = GWT.create(IUISiteService.class);
	private SitesConstants constants = GWT.create(SitesConstants.class);
	
	private boolean distSitesLoaded, trackSitesLoaded;
	
	public SitesActivityResultsPanel() {
		buildComponents();
		loadDistSitesData();
		this.initWidget(mainContainer);
	}

	private void buildComponents() {
		mainContainer = new VerticalContainer();
		mainContainer.setWidth("100%");
		mainContainer.setSpacing(2);

		header = new HeaderPanel("Sites Activity Search Results");
		mainContainer.add(header);

		messageArea = new MessageArea();
		messageArea.reset();
		mainContainer.add(messageArea);
		
	    distTablesContainer = new VerticalContainer();
	    distTablesContainer.setWidth("100%");
	    distTablesContainer.setSpacing(2);
	    
		resizableContainer = new ResizableContainer(distTablesContainer, DIST_SITES_TAB_NAME, null);
		resizableContainer.addHeightOffsettingWidget(header);
		resizableContainer.addHeightOffsettingWidget(messageArea);
		resizableContainer.setOffsetHeight(10);
		mainContainer.add(resizableContainer);
		
		resizableContainer.addButton(DIST_SITES_TAB_NAME, makeExportButton(UISiteType.DISTRIBUTION));
		resizableContainer.addButton(DIST_SITES_TAB_NAME, makeCancelButton());
		
	    trackTablesContainer = new VerticalContainer();
	    trackTablesContainer.setWidth("100%");
	    resizableContainer.addTab(trackTablesContainer, TRACK_SITES_TAB_NAME);

		resizableContainer.addButton(TRACK_SITES_TAB_NAME, makeExportButton(UISiteType.TRACKING));
		resizableContainer.addButton(TRACK_SITES_TAB_NAME, makeCancelButton());

	    resizableContainer.addSelectionHandler(new SelectionHandler<Integer>() {
	    	@Override
	    	public void onSelection(SelectionEvent<Integer> event) {
	    		switch(event.getSelectedItem()) {
	    		case 0:
	    			loadDistSitesData();
	    			break;
	    		case 1:
	    			loadTrackSitesData();
	    			break;
	    		}
	    	}
	    });

	    resizableContainer.setTabEnabled(TRACK_SITES_TAB_NAME,
	    		SitesActivitySearchPanel.searchForm.trackSiteEnabled);
	}

	private ButtonWidget makeCancelButton() {
		ButtonWidget cancelButton = new ButtonWidget("Cancel", new ClickHandler(){
			@Override
			public void onClick(ClickEvent event) {
				History.newItem("Sites.Activity");
			}
		});
		cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		return cancelButton;
	}

	private ButtonWidget makeExportButton(final UISiteType siteType) {
		ButtonWidget exportButton = new ButtonWidget("Export", new ClickHandler(){
			@Override
			public void onClick(ClickEvent event) {
				StringBuilder sb = new StringBuilder();
				sb.append("ExportSitesActivity?");
				append(SiteActivityExportRequestParams.SITE_TYPE, siteType.name(), sb);
				sb.append("&");
				append(SiteActivityExportRequestParams.DIST_SITE_ID,
						String.valueOf(SitesActivitySearchPanel.searchForm.distSiteId), sb);
				sb.append("&");
				append(SiteActivityExportRequestParams.TRACK_SITE_ID,
						String.valueOf(SitesActivitySearchPanel.searchForm.trackSiteId), sb);
				sb.append("&");
				append(SiteActivityExportRequestParams.DIST_STATUS,
						SitesActivitySearchPanel.searchForm.distStatus.name(), sb);
				sb.append("&");
				append(SiteActivityExportRequestParams.TRACK_STATUS,
						SitesActivitySearchPanel.searchForm.trackStatus.name(), sb);
				sb.append("&");
				append(SiteActivityExportRequestParams.FROM_DATE,
						SitesActivitySearchPanel.searchForm.fromDateStr, sb);
				sb.append("&");
				append(SiteActivityExportRequestParams.TO_DATE,
						SitesActivitySearchPanel.searchForm.toDateStr, sb);
				
				Window.Location.replace(sb.toString());
			}
			
			private void append(String name, String value, StringBuilder sb) {
				sb.append(name).append("=").append(URL.encodeQueryString(value));
			}
		});
		exportButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		return exportButton;
	}

	private void loadDistSitesData() {
		if(distSitesLoaded)
			return;
		messageArea.reset();
		busyIndicator.center();
		service.getDistSiteActivity(
				SitesActivitySearchPanel.searchForm.distSiteId,
				SitesActivitySearchPanel.searchForm.distStatus,
				SitesActivitySearchPanel.searchForm.fromDateStr,
				SitesActivitySearchPanel.searchForm.toDateStr,
				SitesActivitySearchPanel.searchForm.trackSiteId,
				new NeptuneAsyncCallback<SiteActivityTables>() {
					@Override
					public void onNeptuneFailure(Throwable caught) {
						messageArea.setErrorMessage("Unable to get distribution sites activity."
								+ getFailureMessageSuffix(caught));
						busyIndicator.hide();
					}

					@Override
					public void onNeptuneSuccess(SiteActivityTables tables) {
						renderTables(tables, distTablesContainer);
						distSitesLoaded = true;
						busyIndicator.hide();
					}
		});
	}
	
	private void loadTrackSitesData() {
		if(trackSitesLoaded)
			return;
		messageArea.reset();
		busyIndicator.center();
		service.getTrackSiteActivity(
				SitesActivitySearchPanel.searchForm.trackSiteId,
				SitesActivitySearchPanel.searchForm.trackStatus,
				SitesActivitySearchPanel.searchForm.fromDateStr,
				SitesActivitySearchPanel.searchForm.toDateStr,
				SitesActivitySearchPanel.searchForm.distSiteId,
				new NeptuneAsyncCallback<SiteActivityTables>() {
					@Override
					public void onNeptuneFailure(Throwable caught) {
						messageArea.setErrorMessage("Unable to get tracking sites activity."
								+ getFailureMessageSuffix(caught));
						busyIndicator.hide();
					}

					@Override
					public void onNeptuneSuccess(SiteActivityTables tables) {
						renderTables(tables, trackTablesContainer);
						trackSitesLoaded = true;
						busyIndicator.hide();
					}
		});
	}
	
	private void renderTables(SiteActivityTables tables, VerticalContainer container) {
		for(SiteActivityTable table : tables.getTables()) {
			HyperlinkWidget siteNameWidget = new HyperlinkWidget(table.getSiteName(),
					"Sites.View?id=" + table.getSiteId());
			siteNameWidget.addStyleName(SITE_NAME_STYLE);
			container.add(siteNameWidget);
			
			FlexTableContainer flexTable = new FlexTableContainer();
			flexTable.addStyleName(TABLE_STYLE);
			container.add(flexTable);
			
			int row = 0, col = 0;
			flexTable.getRowFormatter().addStyleName(row, HEADER_ROW_STYLE);
			for(String headerColumn : tables.getHeaderRow()) {
				InlineLabelWidget headerColumnWidget = new InlineLabelWidget(headerColumn);
				headerColumnWidget.addStyleName(HEADER_TEXT_STYLE);
				flexTable.setWidget(row, col, headerColumnWidget);
				flexTable.getCellFormatter().setAlignment(row, col,
						HasHorizontalAlignment.ALIGN_CENTER,
						HasVerticalAlignment.ALIGN_MIDDLE);
				col++;
			}
			row = 1;
			for(List<Column> dataRow : table.getDataRows()) {
				flexTable.getRowFormatter().addStyleName(row, DATA_ROW_STYLE);
				col = 0;
				for(Column dataCol : dataRow) {
					flexTable.setWidget(row, col, dataCol.getWidget());
					flexTable.getCellFormatter().setAlignment(row, col,
							HasHorizontalAlignment.ALIGN_CENTER,
							HasVerticalAlignment.ALIGN_MIDDLE);
					col++;
				}
				row++;
			}
			enableSort(flexTable.getElement());
		}
	}

	private String getFailureMessageSuffix(Throwable caught) {
		return " | " + constants.reason() + ": "
				+ (caught != null ? caught.getLocalizedMessage() : "");
	}

	private static native void enableSort(Element element)/*-{
		$wnd.sorttable.makeSortable(element);
	}-*/;


	@Override
	protected void onUnload() {
		if (busyIndicator != null)
			busyIndicator.hide();

		super.onUnload();
	}
}
