package com.ericsson.cms.sites.ui.client.aggregatedview;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.ericsson.cms.sites.ui.client.Anchors;
import com.ericsson.cms.sites.ui.client.entities.TitleMetadata;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UIStatusCount;
import com.ericsson.cms.sites.ui.client.entities.UIStatusCountItem;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

class AggregatedItemDataProvider implements DataProvider<Long, AggregatedItemRecord> {
	private List<UiColumn> uiColumns;	
	private List<Column<?, AggregatedItemRecord>> columns;
	private AggregatedViewTab parent;	
	private PageFeature parentPageFeature;
	private TitleClientBundle bundle = new TitleClientBundle();

	private IUIAgggregatedViewServiceAsync service = GWT.create(IUIAgggregatedViewService.class);
	public static final String TITLE_ID_COLUMN_NAME = "titleId";
	private static String HREF_TITLE_ID = "Content.Search.Id=";
	private static final String CONTENT_VIEW_PERMISSION = "AssetManagement_View";

	public AggregatedItemDataProvider (AggregatedViewTab parent) {
		this.parent = parent;
	}
	
	public void init(final AsyncCallback<Void> callback) {
		columns = new ArrayList<Column<?, AggregatedItemRecord>>();

		//service to get title metadata
		SpecificationServiceAsync specService = GWT.create(SpecificationService.class);		
		specService.getTable(UIStatusCountItem.METADATA_TABLE_NAME, new NeptuneAsyncCallback<UiTable>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(UiTable table) {
				// Initialize Title metadata Columns 
				uiColumns = table.getColumns();				
				if(uiColumns != null) {
					for(int i=0; i<uiColumns.size(); i++) {
						final UiColumn uiColumn = uiColumns.get(i);
						String colInternalName = TableColumnNameHelper.getColumnName(uiColumn.getName(), uiColumn.getSectionName());
						
						ColumnBase<String, AggregatedItemRecord> column=null;
						if (i > 0) {
							column =
								new ColumnBase<String, AggregatedItemRecord>(colInternalName, uiColumn.getDisplayName()) {
									public View<String> getView(final AggregatedItemRecord record) {
										UIStatusCountItem item = record.getAggregatedItem();	    
										for (final TitleMetadata t : item.getMetadata()) {
											String colInternalName = TableColumnNameHelper.getColumnName(t.getName(), t.getAssetType());
											if(colInternalName.equals(getName())) {
												LabelStringView view = new LabelStringView(t.getValue());
												return view;
										    }
									}
									return new LabelStringView("");								
								}
								};		
						}
						else { //Use anchor for first title metadata column
							column =
							new ColumnBase<String, AggregatedItemRecord>(colInternalName, uiColumn.getDisplayName()) {
								public View<String> getView(final AggregatedItemRecord record) {
									UIStatusCountItem item = record.getAggregatedItem();	    
									for (final TitleMetadata t : item.getMetadata()) {
										String colInternalName = TableColumnNameHelper.getColumnName(t.getName(), t.getAssetType());
										if(colInternalName.equalsIgnoreCase(getName())) {
											return new View<String>() {
												@Override
												public String getStyleName() {
													if (ClientAuthorizationManager.isAuthorized(CONTENT_VIEW_PERMISSION)) {
														return TableConstants.STYLE_DATA_LINK;
													}
													return TableConstants.STYLE_DATACELL_TEXT;
												}

												@Override
												public Widget getWidget() {
													String titleId = record.getAggregatedItem().getTitleId().toString();
													
													if (ClientAuthorizationManager.isAuthorized(CONTENT_VIEW_PERMISSION)) {
														//Add sites anchor for this page to History object so that we can return to this page
														//when user do a "cancel" on the title details metadata tab.
														UISite uiSite = parent.getUiSite();
			                                            String sourceAnchor = Anchors.getAnchor(uiSite.getId(), uiSite.getParentId(), parent.getName());
														HyperlinkWidget anchor = new HyperlinkWidget(t.getValue(), HREF_TITLE_ID + titleId + "&" + sourceAnchor);
														anchor.setStyleName(TableConstants.STYLE_DATA_LINK);
														return anchor;
													} else {
														return new LabelStringView(titleId).getWidget();
													}
												}

												@Override
												public void release() {
												}
											};
									    }
								}
								return new LabelStringView("");								
							}
							};		
						}
						column.setCellStyle(getColumnCellStyle(uiColumn));
						columns.add(column);
						
					}
				}
				
				// Distribution and Tracking status count columns 
				Iterator<String> iterDist =  UIStatusCountItem.getStatusNames().iterator();
				while ( iterDist.hasNext() == true) {
					String statusName = iterDist.next();
					String statusDisplayName = bundle.getDistributionStatusName(statusName);
					columns.add(prepareDistStatusCountColumn(statusName, statusDisplayName));
				}	
				Iterator<String> iterTrack =  UIStatusCountItem.getTrackStatusNames().iterator();
				while ( iterTrack.hasNext() == true) {
					String statusName = iterTrack.next();
					String statusDisplayName = bundle.getTrackingStatusName(statusName);
					columns.add(prepareTrackStatusCountColumn(statusName, statusDisplayName));
				}	
				
				callback.onSuccess(null);
			}
		});
	}
	
	
	/*
	 * Determine the style to use based on the data type of the column data
	 */
	private String getColumnCellStyle(UiColumn column) {
		String style = TableConstants.STYLE_DATACELL_GENERAL;
		if (column.getDataType() != null) {
			switch (column.getDataType()) {
				case BOOLEAN:
				case STRING:
					style = TableConstants.STYLE_DATACELL_TEXT;
					break;
				case INTEGER:
				case FLOAT:
					style = TableConstants.STYLE_DATACELL_NUMERIC;
					break;
				case DATE:
				case TIME:
					style = TableConstants.STYLE_DATACELL_DATE;
					break;
			}
		}

		return style;
	}
	
	private Column<String, AggregatedItemRecord> prepareDistStatusCountColumn(final String colName, final String displayName) {
		ColumnBase<String, AggregatedItemRecord> column = null;

		column = new ColumnBase<String, AggregatedItemRecord>(colName, displayName) {
			@Override
			public View<String> getView(final AggregatedItemRecord record) {

				return new View<String>() {
					@Override
					public String getStyleName() {
						return TableConstants.STYLE_DATA_LINK;
					}

					@Override
					public Widget getWidget() {
						Integer count = record.getAggregatedItem().getStatusCount(colName);
						if (count != null) {
							LabelWidget label = new LabelWidget(count.toString());
							if (count.intValue() > 0) {
								label.addClickHandler(new ClickHandler() {
										public void onClick(ClickEvent event) {
											Long masterTitleId = record.getAggregatedItem().getTitleId();
											parent.setAnchorParams(masterTitleId, true, colName); 
											parent.showLocalTitleSiteView();
										}
								});
							}
							return label;
						}
						else
							return null;
					}

					@Override
					public void release() {
					}
				};
			}

		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_NUMERIC);
		
		return column;	
	}

	private Column<String, AggregatedItemRecord> prepareTrackStatusCountColumn(final String colName, final String displayName) {
		ColumnBase<String, AggregatedItemRecord> column = null;

		column = new ColumnBase<String, AggregatedItemRecord>(colName, displayName) {
			@Override
			public View<String> getView(final AggregatedItemRecord record) {

				return new View<String>() {
					@Override
					public String getStyleName() {
						return TableConstants.STYLE_DATA_LINK;
					}

					@Override
					public Widget getWidget() {
						Integer count = record.getAggregatedItem().getTrackStatusCount(colName);
						if (count != null) {
							LabelWidget label = new LabelWidget(count.toString());
							if (count.intValue() > 0) {
								label.addClickHandler(new ClickHandler() {
								public void onClick(ClickEvent event) {
									Long masterTitleId = record.getAggregatedItem().getTitleId();
									parent.setAnchorParams(masterTitleId, false, colName);
									parent.showLocalTitleSiteView();
								}
								});
							}
							return label;
						}
						else
							return null;
					}

					@Override
					public void release() {
					}
				};
			}

		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_NUMERIC);
		
		return column;	
	}
		
	@Override
	public List<Column<?, AggregatedItemRecord>> getColumns() {
		return this.columns;
	}

	@Override
	public void getRecord(Long key, AsyncCallback<AggregatedItemRecord> callback) {
		/* should never be used */
		throw new UnsupportedOperationException();
	}

	@Override
	public void getRecords(final AsyncCallback<List<AggregatedItemRecord>> callback) {
		int length = getParentPageFeature().getPageSize();
		int start = (getParentPageFeature().getPageNumber() - 1) * length;

		parent.showBusyIndicator();
		service.getPagedStatusCount(parent.getSiteId(), start, length, false, new NeptuneAsyncCallback<UIStatusCount>() {
			
		@Override
		public void onNeptuneFailure(Throwable caught) {
			getParentPageFeature().setRecordCount(-1);				
			parent.handleGetRecordsFailure(caught);
		}

		@Override
		public void onNeptuneSuccess(UIStatusCount countItemList) {
			int recCount = (int)countItemList.getTotalCount();
			getParentPageFeature().setRecordCount(recCount); 
			
			List<AggregatedItemRecord> records = new ArrayList<AggregatedItemRecord>();
			for (UIStatusCountItem countItem : countItemList.getItems()) {
				records.add(new AggregatedItemRecord(countItem));
			}
			callback.onSuccess(records);
			parent.handleGetRecordsSuccess(countItemList);
		}});		
		
	}
	

	@Override
	public void initialize(AsyncCallback<Void> callback) {
		/* do nothing */
		callback.onSuccess(null);
	}

	@Override
	public boolean isCheckboxEnabled() {
		return false;
	}

	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}

	/**
	 * @return the parentPageFeature
	 */
	public PageFeature getParentPageFeature() {
		return parentPageFeature;
	}

	/**
	 * @param parentPageFeature the parentPageFeature to set
	 */
	public void setParentPageFeature(PageFeature parentPageFeature) {
		this.parentPageFeature = parentPageFeature;
	}
	
}
