package com.ericsson.cms.sites.ui.client.aggregatedview;

import java.util.HashMap;
import java.util.Map;

import com.ericsson.cms.sites.ui.client.Anchors;
import com.ericsson.cms.sites.ui.client.ISiteTab;
import com.ericsson.cms.sites.ui.client.SitesTabContainer.SiteCRUDNotifier;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.entities.UIStatusCount;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.tandbergtv.cms.portal.content.client.PreferenceKeys;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class AggregatedViewTab extends ScrollContainer implements ISiteTab{
	private static final int MAIN_PANEL_OFFSET_HEIGHT = 250;

	//widgets
	private VerticalContainer mainContainer;
	private VerticalContainer aggViewContainer;
	private LabelWidget blankLabel = new LabelWidget("");
	private PageFeature pageFeature;
	private AggregatedItemDataProvider dataProviderAggregatedCounts;
	private Table<Long, AggregatedItemRecord> tableAggregatedCounts;	
	private BusyIndicator busyIndicator = new BusyIndicator();
	private TitleSiteListPanel localTitleSitePanel;
	
	private MessageArea messageArea;

	private UISite site;
	private UIStatusCount statusCount = null;
	private String specificationName;
	private Timer refreshTimer;
	private int refreshPeriod;
	
	private static final int SPACING = 2;
	private static final String STYLE_NAME = "content-TitleListsPanel";
	private static final String AGGREGATED_VIEW_PANEL_REFRESH_KEY = "site.aggregatedview.refreshTime";

	private Map<String, String> anchorParams = null;
	//Anchor used for Detailed view(LocalTitleSiteView)
	private static final String TITLE_ANCHOR = "AggregatedView.titleId";
	private static final String DISTRIBUTION_ANCHOR = "AggregatedView.isDistribution";
	private static final String STATUS_ANCHOR = "AggregatedView.statusType";
	private int DEFAULT_AGGREGATED_VIEW_PANEL_REFRESH_TIME = 60;
	
	private HandlerRegistration windowRegistration = null;

	public AggregatedViewTab(Map<String, String> info) {
		initWidgets(info.get(PreferenceKeys.SPECIFICATION_NAME));

		this.refreshPeriod = getRefreshPeriod(info);
		this.refreshTimer = new Timer() {
			@Override
			public void run() {
				showView(site.getId());
			}
		};
		
		/* Show a blank label in the container */
		LabelWidget blankLabel = new LabelWidget("");
		this.setWidget(blankLabel);				

		Scheduler.get().scheduleDeferred(new ScheduledCommand() {
			@Override
			public void execute() {
				updateMainPanelSize();
			}
		});
	}
	
	private void initWidgets(String specificationName) {
		this.specificationName = specificationName;
		mainContainer = new VerticalContainer();
		aggViewContainer = new VerticalContainer();
		aggViewContainer.setSpacing(SPACING);
		aggViewContainer.setStylePrimaryName(STYLE_NAME);

		init();		
	}	

	private void init() {
		dataProviderAggregatedCounts = new AggregatedItemDataProvider(this);		
		dataProviderAggregatedCounts.init(new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				Window.alert("Failed to initialize Aggregated View Data Provider. Reason: " + ((caught != null) ? caught.getMessage() : ""));
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				tableAggregatedCounts = new Table<Long, AggregatedItemRecord>(dataProviderAggregatedCounts);
				// page feature
				pageFeature = new PageFeatureImpl();
				dataProviderAggregatedCounts.setParentPageFeature(pageFeature);						 
				tableAggregatedCounts.addPageFeature(pageFeature);	
				aggViewContainer.add(tableAggregatedCounts);
				mainContainer.add(aggViewContainer);				
				localTitleSitePanel = new TitleSiteListPanel(AggregatedViewTab.this,specificationName);
				localTitleSitePanel.setVisible(false);
				mainContainer.add(localTitleSitePanel);
			}});
	}
	
	/**
	 * Gets refresh period from configuration.
	 * 
	 * @param info
	 * @return
	 */
	private int getRefreshPeriod(Map<String, String> info){
		String refreshPeriod = info.get(AGGREGATED_VIEW_PANEL_REFRESH_KEY);
		try{
			int refresh = Integer.parseInt(refreshPeriod.trim());
			if(refresh < DEFAULT_AGGREGATED_VIEW_PANEL_REFRESH_TIME) 
				refresh = DEFAULT_AGGREGATED_VIEW_PANEL_REFRESH_TIME; // validate if configured value is less than default 
			
			return refresh * 1000; // in millis
			
		}
		catch(Exception ex){
			return DEFAULT_AGGREGATED_VIEW_PANEL_REFRESH_TIME * 1000; // in millis
		}
	}
	
	private void refreshAggregatedCountsTable(){
		if (!tableAggregatedCounts.isInitialized()) {
			tableAggregatedCounts.initialize(new NeptuneAsyncCallback<Void>() {
				@Override
				public void onNeptuneFailure(Throwable caught) {
				}

				@Override
				public void onNeptuneSuccess(Void result) {
					tableAggregatedCounts.refresh();
				}
			});
		} else {
			pageFeature.reset();
			tableAggregatedCounts.refresh();
		}
	}
		
	void handleGetRecordsSuccess(UIStatusCount statusCount) {
		this.statusCount = statusCount;
		busyIndicator.hide();
		if (statusCount.getItems().size() == 0) {
			//TODO messages.noStatusPresentForSite();
			String message = "No Status present for this site" ; //messages.noStatusPresentForSite();
			tableAggregatedCounts.setVisible(false);
			messageArea.setInfoMessage(message);
			updateSizeForMessageArea();
		} 
		else {
			messageArea.setInfoMessage(null);
			updateSizeForMessageArea();
			tableAggregatedCounts.setVisible(true);
		}
		
		/* Show the main container if not already visible */
		if (getWidget() != mainContainer)
			setWidget(mainContainer);
	}

	void handleGetRecordsFailure(Throwable caught) {
		tableAggregatedCounts.setVisible(false);
		busyIndicator.hide();

		messageArea.setErrorMessage(caught.getLocalizedMessage());
		updateSizeForMessageArea();
		/* Show the main container if not already visible */
		if (getWidget() != mainContainer)
			setWidget(mainContainer);
	}
	
	UIStatusCount getUIStatusCount () {
		return statusCount;
	}
	
	int getSiteId () {
		return site.getId();
	}
	
	public UISite getUiSite() {
		return site;
	}
	
	String getSpecificationName() {
		return specificationName;
	}
	
	void showBusyIndicator() {
		busyIndicator.center();		
	}
	
	public void showView(int siteId) {
		String masterTitleId=null;
		String statusType=null;
		String isDist=null;
		if (anchorParams != null) {
			masterTitleId = anchorParams.get(TITLE_ANCHOR);
			isDist = anchorParams.get(DISTRIBUTION_ANCHOR);
			statusType = anchorParams.get(STATUS_ANCHOR);
		}
		if ( (masterTitleId != null && statusType != null) && isDist != null)
			showLocalTitleSiteView();
		else {
			aggViewContainer.setVisible(true);
			localTitleSitePanel.setVisible(false);
			refreshAggregatedCountsTable();
		}
	}
	
	public void showLocalTitleSiteView() {
		aggViewContainer.setVisible(false);
		localTitleSitePanel.setVisible(true);
		localTitleSitePanel.showView(statusCount.getSiteId(), Long.parseLong(anchorParams.get(TITLE_ANCHOR)),
			       Boolean.parseBoolean(anchorParams.get(DISTRIBUTION_ANCHOR)), anchorParams.get(STATUS_ANCHOR));
	}

	public void setAnchorParams(long masterTitleId, boolean isDistributionStatus, String statusType) {
		if (anchorParams == null)
			anchorParams = new HashMap<String,String>();
		anchorParams.put(TITLE_ANCHOR, String.valueOf(masterTitleId));
		anchorParams.put(DISTRIBUTION_ANCHOR, String.valueOf(isDistributionStatus));
		anchorParams.put(STATUS_ANCHOR, statusType);
	}
	

	public String getAnchorForDetailedView() {
		StringBuilder str = new StringBuilder( Anchors.getAnchor(site.getId(), site.getParentId(), getName()));
		str.append("&"+TITLE_ANCHOR + "=" + anchorParams.get(TITLE_ANCHOR));
		str.append("&"+DISTRIBUTION_ANCHOR + "=" + anchorParams.get(DISTRIBUTION_ANCHOR));
		str.append("&"+STATUS_ANCHOR + "=" + anchorParams.get(STATUS_ANCHOR));
		return str.toString();
	}
	
	@Override
	public String getName() {
		return "Aggregated View";
	}

	@Override
	public String getDisplayName() {
		// TODO need to externalize display names
		return "Aggregated View" ; //constants.aggregatedViewTabName();
	}

	@Override
	public void setCRUDNotifier(SiteCRUDNotifier crudNotifier) {
		
	}

	@Override
	public boolean setSite(UISite site, Map<String, String> params) {
		this.site = site;
		anchorParams = params;
		if(site == null || site.getType() == UISiteType.TRACKING) {
			return false;
		}
				
		return true;
	}

	@Override
	public void setSelected(boolean selected) {
		if (site == null)
			return;
		/* no aggregated view for tracking site */
		if(site.getType() == UISiteType.TRACKING) {
			aggViewContainer.setVisible(false);
			localTitleSitePanel.setVisible(false);
			this.setWidget(blankLabel);	 			
			return;
		}

		if (selected == true) {
			History.newItem(Anchors.getAnchor(site.getId(), site.getParentId(), getName()), false);
			refreshTimer.scheduleRepeating(refreshPeriod);
			showView(site.getId());
		}
		else {
			refreshTimer.cancel();
		}
	}

	/* (non-Javadoc)
	 * @see com.google.gwt.user.client.ui.Panel#onLoad()
	 */
	@Override
	protected void onLoad() {
		super.onLoad();

		windowRegistration = Window.addResizeHandler(new ResizeHandler() {
			public void onResize(ResizeEvent event) {
				updateMainPanelSize();
			}
		});
	}

	/* (non-Javadoc)
	 * @see com.google.gwt.user.client.ui.Panel#onUnload()
	 */
	@Override
	protected void onUnload() {
		windowRegistration.removeHandler();
		windowRegistration = null;

		refreshTimer.cancel();
		busyIndicator.hide();
		super.onUnload();
	}

	@Override
	public void setMessageArea(MessageArea messageArea) {
		this.messageArea = messageArea;
	}
	
	protected void updateMainPanelSize() {
		int offsetHeight = MAIN_PANEL_OFFSET_HEIGHT;
		
		this.setHeight(Window.getClientHeight() - offsetHeight + "px");
	}

	private void updateSizeForMessageArea() {
		this.setHeight((this.getOffsetHeight() - messageArea.getOffsetHeight()) + "px");
	}
}
