package com.ericsson.cms.sites.ui.client.aggregatedview;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.sites.ui.client.entities.TitleMetadata;
import com.ericsson.cms.sites.ui.client.entities.UITitleSiteList;
import com.ericsson.cms.sites.ui.client.entities.UITitleSiteListItem;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public class TitleSiteListDataProvider  implements DataProvider<Long, TitleSiteItemRecord>{
	private TitleSiteListPanel view;
	private List<UiColumn> uiColumns;
	private List<Column<?, TitleSiteItemRecord>> columns = new ArrayList<Column<?, TitleSiteItemRecord>>();

	private IUIAgggregatedViewServiceAsync service = GWT.create(IUIAgggregatedViewService.class);
	private PageFeature parentPageFeature;

	public static final String TITLE_ID_COLUMN_NAME = "titleId";
	public static final String SITE_COLUMN_NAME = "siteName";
	private static String HREF_TITLE_ID = "Content.Search.Id=";
	private static final String CONTENT_VIEW_PERMISSION = "AssetManagement_View";
	
	public TitleSiteListDataProvider (TitleSiteListPanel parent) {
		this.view = parent;
	}

	public void init(final AsyncCallback<Void> callback) {
		//service to get title metadata
		SpecificationServiceAsync specService = GWT.create(SpecificationService.class);		
		specService.getTable(UITitleSiteListItem.METADATA_TABLE_NAME, new NeptuneAsyncCallback<UiTable>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(UiTable table) {

				//TODO : externalize all display names............
				String colName = TITLE_ID_COLUMN_NAME;
				String displayName = "Title ID"; 
			
				/* Title Id Column */
				columns.add(prepareTitleIdColumn(colName,displayName));
				
				/* Initialize Title metadata Columns */
				uiColumns = table.getColumns();				
				if(uiColumns != null) {
					for(final UiColumn uiColumn : uiColumns) {
						String colInternalName = TableColumnNameHelper.getColumnName(uiColumn.getName(), uiColumn.getSectionName());
						ColumnBase<String, TitleSiteItemRecord> column =
							new ColumnBase<String, TitleSiteItemRecord>(colInternalName, uiColumn.getDisplayName()) {
								public View<String> getView(TitleSiteItemRecord record) {
									UITitleSiteListItem item = record.getTitleSiteItem();	    
									for (TitleMetadata t : item.getMetadata()) {
										String colInternalName = TableColumnNameHelper.getColumnName(t.getName(), t.getAssetType());
										if(colInternalName.equalsIgnoreCase(getName())) {
											LabelStringView view = new LabelStringView(t.getValue());
											return view;
									}
								}
								return new LabelStringView("");								
							}
						};
						column.setCellStyle(getColumnCellStyle(uiColumn));
						columns.add(column);
					}
				}
				
				/* Site Column */
				TitleSiteItemColumn column = null;	
				//TODO: externalize display name
				displayName = "Site";
				column = new TitleSiteItemColumn(SITE_COLUMN_NAME, displayName) {
					protected String getColumnText(TitleSiteItemRecord record) {
						return record.getTitleSiteItem().getSiteName();
					}
				};
				column.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
				columns.add(column);
				
				callback.onSuccess(null);
			}
		});
	}
		
	private Column<String, TitleSiteItemRecord> prepareTitleIdColumn(final String colName, final String displayName) {
		ColumnBase<String, TitleSiteItemRecord> column = null;

		column = new ColumnBase<String, TitleSiteItemRecord>(colName, displayName) {
			@Override
			public View<String> getView(final TitleSiteItemRecord record) {

				return new View<String>() {
					@Override
					public String getStyleName() {
						if (ClientAuthorizationManager.isAuthorized(CONTENT_VIEW_PERMISSION)) {
							return TableConstants.STYLE_DATA_LINK;
						} 
						return TableConstants.STYLE_DATACELL_TEXT;
					}

					@Override
					public Widget getWidget() {
						String titleId = record.getTitleSiteItem().getLocalTitleId().toString();
						
						if (ClientAuthorizationManager.isAuthorized(CONTENT_VIEW_PERMISSION)) {
							//Add sites anchor for this page to History object so that we can return to this page
							//when user do a "cancel" on the title details metadata tab.
							String sourceAnchor = view.getParent().getAnchorForDetailedView();
							HyperlinkWidget anchor = new HyperlinkWidget(titleId, HREF_TITLE_ID + titleId + "&" + sourceAnchor);
							anchor.setStyleName(TableConstants.STYLE_DATA_LINK);
							return anchor;
						} else {
							return new LabelStringView(titleId).getWidget();
						}
					}

					@Override
					public void release() {
					}
				};
			}
		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
		
		return column;	
	}
	
	/*
	 * Determine the style to use based on the data type of the column data
	 */
	private String getColumnCellStyle(UiColumn column) {
		String style = TableConstants.STYLE_DATACELL_GENERAL;
		if (column.getDataType() != null) {
			switch (column.getDataType()) {
				case BOOLEAN:
				case STRING:
					style = TableConstants.STYLE_DATACELL_TEXT;
					break;
				case INTEGER:
				case FLOAT:
					style = TableConstants.STYLE_DATACELL_NUMERIC;
					break;
				case DATE:
				case TIME:
					style = TableConstants.STYLE_DATACELL_DATE;
					break;
			}
		}

		return style;
	}
		
	@Override
	public List<Column<?, TitleSiteItemRecord>> getColumns() {
		return this.columns;
	}

	@Override
	public void getRecord(Long key, AsyncCallback<TitleSiteItemRecord> callback) {
		throw new UnsupportedOperationException();
	}
	
	public void getRecords(final AsyncCallback<List<TitleSiteItemRecord>> callback) {
		final int length = getParentPageFeature().getPageSize();
		final int start = (getParentPageFeature().getPageNumber() - 1) * length;
		
		view.showBusyIndicator();
		service.getLocalTitleSiteList(view.getSiteId(), view.getMasterTitleId(), view.isDistributionStatus(),view.getStatusType(), new NeptuneAsyncCallback<UITitleSiteList>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				getParentPageFeature().setRecordCount(-1);				
				view.handleGetRecordsFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(UITitleSiteList titleSiteList) {
				int recCount = titleSiteList.getItemCount();
				getParentPageFeature().setRecordCount(recCount);
				
				List<TitleSiteItemRecord> records = new ArrayList<TitleSiteItemRecord>();
				for (UITitleSiteListItem titleSiteItem : titleSiteList.getPagedItems(start, length)) {
					records.add(new TitleSiteItemRecord(titleSiteItem));
				}
				callback.onSuccess(records);
				view.handleGetRecordsSuccess(titleSiteList);
			}});		
	}
	
	@Override
	public void initialize(AsyncCallback<Void> callback) {
		/* do nothing */
		callback.onSuccess(null);
	}

	@Override
	public boolean isCheckboxEnabled() {
		return false;
	}

	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}	

	/**
	 * @return the parentPageFeature
	 */
	public PageFeature getParentPageFeature() {
		return parentPageFeature;
	}

	/**
	 * @param parentPageFeature the parentPageFeature to set
	 */
	public void setParentPageFeature(PageFeature parentPageFeature) {
		this.parentPageFeature = parentPageFeature;
	}
	
}
