package com.ericsson.cms.sites.ui.client.aggregatedview;

import com.ericsson.cms.sites.ui.client.entities.UITitleSiteList;
import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class TitleSiteListPanel extends SimpleContainer{
	private UITitleSiteList titleSiteList = null;
	//widgets
	private AggregatedViewTab parent;
	private VerticalContainer mainContainer;
	private LabelWidget errorMsgLabel;
	private LabelWidget infoMsgLabel;
	private TitleSiteListDataProvider dataProviderTitleSiteList;
	private Table<Long, TitleSiteItemRecord> tableTitleSiteList;	
	private BusyIndicator busyIndicator = new BusyIndicator();
	LabelWidget blankLabel = new LabelWidget("");

	private String specificationName;
	private int siteId;
	private long masterTitleId; 
	private boolean isDistributionStatus;
	private String statusType;
	
	private static final int SPACING = 2;
	private static final String STYLE_NAME = "content-TitleListsPanel";
	
	public TitleSiteListPanel(AggregatedViewTab parent, String specificationName) {
		this.parent = parent;
		this.specificationName = specificationName;
		initWidgets();		
	}
	
	public UITitleSiteList getTitleSiteList() {
		return titleSiteList;
	}

	public AggregatedViewTab getParent() {
		return parent;
	}
	
	private void initWidgets() {
		mainContainer = new VerticalContainer();
		mainContainer.setSpacing(SPACING);
		mainContainer.setStylePrimaryName(STYLE_NAME);

		infoMsgLabel = new LabelWidget();
		infoMsgLabel.setVisible(false);
		errorMsgLabel = new LabelWidget();
		errorMsgLabel.setVisible(false);
	
		mainContainer.add(infoMsgLabel);
		mainContainer.add(errorMsgLabel);
		initDataProvider("");
	}	

	private void initDataProvider(final String infoMessage) {
		dataProviderTitleSiteList = new TitleSiteListDataProvider(this);		

		dataProviderTitleSiteList.init(new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				Window.alert("Failed to initialize Title Sites Data Provider. Reason: " + ((caught != null) ? caught.getMessage() : ""));
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				initTable();
			}});

	}

	private void initTable(){
		tableTitleSiteList = new Table<Long, TitleSiteItemRecord>(dataProviderTitleSiteList);
		PageFeature pageFeature = new PageFeatureImpl();
		dataProviderTitleSiteList.setParentPageFeature(pageFeature);						 
		tableTitleSiteList.addPageFeature(pageFeature);	
		
		mainContainer.add(tableTitleSiteList);
	}	
	
	private void refreshTable(){
		if (!tableTitleSiteList.isInitialized()) {
			tableTitleSiteList.initialize(new NeptuneAsyncCallback<Void>() {
				@Override
				public void onNeptuneFailure(Throwable caught) {
				}

				@Override
				public void onNeptuneSuccess(Void result) {
					tableTitleSiteList.refresh();
				}
			});
		} else {
			tableTitleSiteList.refresh();
		}
	}
	
	public void handleGetRecordsSuccess(UITitleSiteList titleSiteList) {
		busyIndicator.hide();
		this.titleSiteList = titleSiteList;
		errorMsgLabel.setVisible(false);
		if (titleSiteList.getItems().size() == 0) {
			//TODO messages.noTitlePresentForStatus();
			String message = "No titles present for this status" ; 
			tableTitleSiteList.setVisible(false);
			infoMsgLabel.setText(message);
			infoMsgLabel.setVisible(true);
		} 
		else {
			infoMsgLabel.setVisible(false);
			tableTitleSiteList.setVisible(true);
		}
		
		/* Show the main container if not already visible */
		if (getWidget() != mainContainer)
			setWidget(mainContainer);
	}

	public void handleGetRecordsFailure(Throwable caught) {
		busyIndicator.hide();
		tableTitleSiteList.setVisible(false);
		infoMsgLabel.setVisible(false);

		errorMsgLabel.setText(caught.getMessage());
		errorMsgLabel.setVisible(false);
		/* Show the main container if not already visible */
		if (getWidget() != mainContainer)
			setWidget(mainContainer);
	}

	public void showView(int siteId, long masterTitleId, boolean isDistributionStatus, String statusType) {
		this.siteId =siteId;
		this.masterTitleId = masterTitleId;
		this.isDistributionStatus = isDistributionStatus;
		this.statusType = statusType;

		this.setWidget(blankLabel);	 			
		refreshTable();
	}
	
	void showBusyIndicator() {
		busyIndicator.center();		
	}
	
	public String getSpecificationName() {
		return specificationName;
	}

	public int getSiteId() {
		return siteId;
	}

	public long getMasterTitleId() {
		return masterTitleId;
	}

	public boolean isDistributionStatus() {
		return isDistributionStatus;
	}

	public String getStatusType() {
		return statusType;
	}	
}
