package com.ericsson.cms.sites.ui.client.bundle;

import com.ericsson.cms.sites.ui.client.entities.UISiteTreeNode;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.images.ISiteClientBundle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Image;

public class SiteClientBundle {

	private ISiteClientBundle titleBundle = GWT.create(ISiteClientBundle.class);
	private SitesConstants constants = GWT.create(SitesConstants.class);

	public void updateSiteIcon(Image icon, UISiteTreeNode siteNode, boolean isLocalError) {
		boolean isError;
		if (isLocalError == true)
			isError = siteNode.isError();
		else {//show error if either one is has error condition
			isError = ( siteNode.isError() | siteNode.isDescendantHasError()); //show error if either one is has error cond
		}
		switch (siteNode.getType()) {
			case LOGICAL:
				updateLogicalSiteIcon(icon, siteNode.isActive(), isError);
				break;
				
			case DISTRIBUTION:
				updateDistributionSiteIcon(icon, siteNode.isActive(), isError);
				break;

			case MEDIAPATH_DISTRIBUTION:
				updateMediaPathDistributionSiteIcon(icon, siteNode.isActive(), isError);
				break;

			case TRACKING:
				updateTrackingSiteIcon(icon, siteNode.isShared(), siteNode.isActive(), isError);
		}
	}
	
	public void updateTrackingSiteIcon(Image icon, boolean isShared, boolean isActive, boolean isError ) {
		if (isShared == true) {
			if (isError == true)
				updateIcon(icon, "sharedTrackingSiteError");
			else if (isActive == false)
				updateIcon(icon, "sharedTrackingSiteDisabled");
			else
				updateIcon(icon, "sharedTrackingSite");
		}
		else {
			if (isError == true)
				updateIcon(icon, "trackingSiteError");
			else if (isActive == false)
				updateIcon(icon, "trackingSiteDisabled");
			else
				updateIcon(icon, "trackingSite");			
		}
	}	

	public void updateDistributionSiteIcon(Image icon, boolean isActive, boolean isError ) {
		if (isError == true)
			updateIcon(icon, "distributionSiteError");
		else if (isActive == false)
			updateIcon(icon, "distributionSiteDisabled");
		else
			updateIcon(icon, "distributionSite");
	}	

	public void updateMediaPathDistributionSiteIcon(Image icon, boolean isActive, boolean isError ) {
		if (isError == true)
			updateIcon(icon, "mediaPathDistributionSiteError");
		else if (isActive == false)
			updateIcon(icon, "mediaPathDistributionSiteDisabled");
		else
			updateIcon(icon, "mediaPathDistributionSite");
	}	

	public void updateLogicalSiteIcon(Image icon, boolean isActive, boolean isError ) {
		if (isError == true)
			updateIcon(icon, "logicalSiteError");
		else if (isActive == false)
			updateIcon(icon, "logicalSiteDisabled");
		else
			updateIcon(icon, "logicalSite");
	}	
	
	/**
	 * Update the image with the appropriate icon defined in the {@link ISiteClientBundle}. Provide
	 * the method name from the bundle to update the image with the appropriate icon.
	 * 
	 * @param icon The image to update
	 * @param methodName The method name from {@link ITitleClientBundle}
	 */
	public void updateIcon(Image icon, String methodName) {
		ImageResource resource = (ImageResource) titleBundle.getResource(methodName);
		String title = constants.getString(methodName);
		
		/* Update the image */
		icon.setResource(resource);
		icon.setTitle(title);
	}
	
}
