package com.ericsson.cms.sites.ui.client.entities;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;

public class SchedulesCalendarData implements IsSerializable {
	private int beginningDay;
	private int numDays;
	private long contextId;
	private Map<Integer, UISchedule> schedules = new HashMap<Integer, UISchedule>();
	
	/**
	 * @return the beginningDay
	 */
	public int getBeginningDay() {
		return beginningDay;
	}
	/**
	 * @param beginningDay the beginningDay to set
	 */
	public void setBeginningDay(int beginningDay) {
		this.beginningDay = beginningDay;
	}
	/**
	 * @return the numDays
	 */
	public int getNumDays() {
		return numDays;
	}
	/**
	 * @param numDays the numDays to set
	 */
	public void setNumDays(int numDays) {
		this.numDays = numDays;
	}
	/**
	 * @return the contextId
	 */
	public long getContextId() {
		return contextId;
	}
	/**
	 * @param contextId the contextId to set
	 */
	public void setContextId(long contextId) {
		this.contextId = contextId;
	}
	/**
	 * @return the schedules
	 */
	public Map<Integer, UISchedule> getSchedules() {
		return schedules;
	}
	/**
	 * @param schedules the schedules to set
	 */
	public void setSchedules(Map<Integer, UISchedule> schedules) {
		if(schedules == null)
			this.schedules.clear();
		else
			this.schedules = schedules;
	}
	
	public void add(int date, UISchedule schedule) {
		schedules.put(date, schedule);
	}
	
	public UISchedule getForDate(int date) {
		return schedules.get(date);
	}
}
