package com.ericsson.cms.sites.ui.client.entities;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.view.thumbnail.TitleThumbnailWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITrackingStatus;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;

public class SiteActivityTable implements IsSerializable {
	public static abstract class Column implements IsSerializable {
		//Used in UI
		public abstract Widget getWidget();
		//Used in Export
		public abstract String toString();
	}
	
	public static class TextColumn extends Column {
		protected String text;

		public TextColumn() {}
		
		public TextColumn(Object obj) {
			this.text = String.valueOf(obj);
		}

		public TextColumn(String text) {
			this.text = text;
		}
		
		@Override
		public Widget getWidget() {
			LabelWidget widget = new LabelWidget(text);
			widget.addStyleName(TableConstants.STYLE_DATA_TEXT);
			return widget;
		}
		
		@Override
		public String toString() {
			return (text == null) ? "" : text;
		}
	}
	
	public static class HyperlinkColumn extends TextColumn {
		private String url;

		public HyperlinkColumn() {}
		
		public HyperlinkColumn(String text, String url) {
			super(text);
			this.url = url;
		}
		
		@Override
		public Widget getWidget() {
			HyperlinkWidget widget = new HyperlinkWidget(text, url);
			widget.addStyleName(TableConstants.STYLE_DATA_LINK);
			return widget;
		}
	}
	
	public static abstract class SiteTitleStatusColumn extends Column {
	}
	
	public static class DistTitleStatusColumn extends SiteTitleStatusColumn {
		private UIDistributionStatus status;

		public DistTitleStatusColumn() {}
		
		public DistTitleStatusColumn(UIDistributionStatus status) {
			this.status = status;
		}

		@Override
		public Widget getWidget() {
			ImageWidget image = new ImageWidget();
			new TitleClientBundle().updateDistributionStatusIcon(image, status.name());
			return image;
		}
		
		@Override
		public String toString() {
			return status.toString();
		}
	}
	
	public static class TrackTitleStatusColumn extends SiteTitleStatusColumn {
		private UITrackingStatus status;

		public TrackTitleStatusColumn() {}
		
		public TrackTitleStatusColumn(UITrackingStatus status) {
			this.status = status;
		}
		
		@Override
		public Widget getWidget() {
			ImageWidget image = new ImageWidget();
			new TitleClientBundle().updateTrackingStatusIcon(image, status.name());
			return image;
		}
		
		@Override
		public String toString() {
			return status.toString();
		}
	}
	
	public static class TitleThumbnailColumn extends Column {
		private long titleId;
		
		public TitleThumbnailColumn() {}

		public TitleThumbnailColumn(long titleId) {
			this.titleId = titleId;
		}

		@Override
		public Widget getWidget() {
			TitleThumbnailWidget widget = new TitleThumbnailWidget();
			widget.setInput(titleId, null);
			return widget;
		}
		
		@Override
		public String toString() {
			return String.valueOf(titleId);
		}
	}

	private int siteId;
	private String siteName;
	private List<List<Column>> dataRows = new ArrayList<List<Column>>();

	public SiteActivityTable() {}
	
	public SiteActivityTable(int siteId, String siteName) {
		this.siteId = siteId;
		this.siteName = siteName;
	}
	
	public int getSiteId() {
		return siteId;
	}
	public void setSiteId(int siteId) {
		this.siteId = siteId;
	}
	public String getSiteName() {
		return siteName;
	}
	public void setSiteName(String siteName) {
		this.siteName = siteName;
	}
	public List<List<Column>> getDataRows() {
		return dataRows;
	}
	public void addDataRow(List<Column> dataRow) {
		dataRows.add(dataRow);
	}
}
