package com.ericsson.cms.sites.ui.client.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.scheduling.ui.client.data.UIJob;
import com.google.gwt.user.client.rpc.IsSerializable;

public class UISite implements IsSerializable {
	private Integer id;
	private Integer parentId;
	private String name;
	private UISiteType type;
	private boolean active;
	private boolean shared;
	private String externalId;
	private String description;
	private boolean hasChildren;
	private List<String> fileLookupKeys = new ArrayList<String>();
	private String metadataFormat;
	private UIDistributionOption distributionOption = UIDistributionOption.IMMEDIATE;
	private String distTemplateName;
	private String associatedGroupName;
	private Map<String, String> distConfParams;
	private String exportPluginName;
	private Map<String, String> exportConfParams;
	private Long associatedResourceId;
	private Integer alertDelayPeriod;
	private UIStatusPlugin distUiStatusPlugin;
	private UIStatusPlugin deplUiStatusPlugin;
	
	private List<String> allFileLookupKeys = new ArrayList<String>();
	private List<String> allMetadataFormats = new ArrayList<String>();
	private List<UITemplateInfo> allTemplatesInfo = new ArrayList<UITemplateInfo>();
	private List<UIExportPluginInfo> allExportPluginsInfo = new ArrayList<UIExportPluginInfo>();
	private UIJob timerJob;
	private UISitePartner sitePartner;
	
	/**
	 * @return the id
	 */
	public Integer getId() {
		return id;
	}
	/**
	 * @param id the id to set
	 */
	public void setId(Integer id) {
		this.id = id;
	}
	/**
	 * @return the parentId
	 */
	public Integer getParentId() {
		return parentId;
	}
	/**
	 * @param parentId the parentId to set
	 */
	public void setParentId(Integer parentId) {
		this.parentId = parentId;
	}
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return the active
	 */
	public boolean isActive() {
		return active;
	}
	/**
	 * @param active the active to set
	 */
	public void setActive(boolean active) {
		this.active = active;
	}
	/**
	 * @return the shared
	 */
	public boolean isShared() {
		return shared;
	}
	/**
	 * @param shared the shared to set
	 */
	public void setShared(boolean shared) {
		this.shared = shared;
	}
	/**
	 * @return the externalId
	 */
	public String getExternalId() {
		return externalId;
	}
	/**
	 * @param externalId the externalId to set
	 */
	public void setExternalId(String externalId) {
		this.externalId = externalId;
	}
	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * @return the hasChildren
	 */
	public boolean hasChildren() {
		return hasChildren;
	}
	/**
	 * @param hasChildren the hasChildren to set
	 */
	public void setHasChildren(boolean hasChildren) {
		this.hasChildren = hasChildren;
	}
	/**
	 * @return the type
	 */
	public UISiteType getType() {
		return type;
	}
	/**
	 * @param type the type to set
	 */
	public void setType(UISiteType type) {
		this.type = type;
	}
	/**
	 * @return the alertDelayPeriod
	 */
	public Integer getAlertDelayPeriod() {
		return alertDelayPeriod;
	}
	/**
	 * @param alertDelayPeriod the alertDelayPeriod to set
	 */
	public void setAlertDelayPeriod(Integer alertDelayPeriod) {
		this.alertDelayPeriod = alertDelayPeriod;
	}
	
	/**
	 * @return the fileLookupKeys
	 */
	public List<String> getFileLookupKeys() {
		return fileLookupKeys;
	}

	/**
	 * @param fileLookupKeys the fileLookupKeys to set
	 */
	public void setFileLookupKeys(List<String> fileLookupKeys) {
		this.fileLookupKeys = fileLookupKeys;
	}
	
	/**
	 * @return the metadataFormat
	 */
	public String getMetadataFormat() {
		return metadataFormat;
	}
	
	/**
	 * @param metadataFormat the metadataFormat to set
	 */
	public void setMetadataFormat(String metadataFormat) {
		this.metadataFormat = metadataFormat;
	}
	
	/**
	 * @return the distributionOption
	 */
	public UIDistributionOption getDistributionOption() {
		return distributionOption;
	}
	
	/**
	 * @param distributionOption the distributionOption to set
	 */
	public void setDistributionOption(UIDistributionOption distributionOption) {
		this.distributionOption = distributionOption;
	}
	
	/**
	 * @return the distTemplateName
	 */
	public String getDistTemplateName() {
		return distTemplateName;
	}
	/**
	 * @param distTemplateName the distTemplateName to set
	 */
	public void setDistTemplateName(String distTemplateName) {
		this.distTemplateName = distTemplateName;
	}
	/**
	 * @return the distConfParams
	 */
	public Map<String, String> getDistConfParams() {
		return distConfParams;
	}
	/**
	 * @param distConfParams the distConfParams to set
	 */
	public void setDistConfParams(Map<String, String> distConfParams) {
		this.distConfParams = distConfParams;
	}
	/**
	 * @return the exportPluginName
	 */
	public String getExportPluginName() {
		return exportPluginName;
	}
	/**
	 * @param exportPluginName the exportPluginName to set
	 */
	public void setExportPluginName(String exportPluginName) {
		this.exportPluginName = exportPluginName;
	}
	/**
	 * @return the exportConfParams
	 */
	public Map<String, String> getExportConfParams() {
		return exportConfParams;
	}
	/**
	 * @param exportConfParams the exportConfParams to set
	 */
	public void setExportConfParams(Map<String, String> exportConfParams) {
		this.exportConfParams = exportConfParams;
	}
	/**
	 * @return the associatedResourceId
	 */
	public Long getAssociatedResourceId() {
		return associatedResourceId;
	}
	/**
	 * @param associatedResourceId the associatedResourceId to set
	 */
	public void setAssociatedResourceId(Long associatedResourceId) {
		this.associatedResourceId = associatedResourceId;
	}
	/**
	 * @return the allFileLookupKeys
	 */
	public List<String> getAllFileLookupKeys() {
		return allFileLookupKeys;
	}
	
	/**
	 * @param allFileLookupKeys the allFileLookupKeys to set
	 */
	public void setAllFileLookupKeys(List<String> allFileLookupKeys) {
		this.allFileLookupKeys = allFileLookupKeys;
	}
	
	/**
	 * @return the allMetadataFormats
	 */
	public List<String> getAllMetadataFormats() {
		return allMetadataFormats;
	}
	
	/**
	 * @param allMetadataFormats the allMetadataFormats to set
	 */
	public void setAllMetadataFormats(List<String> allMetadataFormats) {
		this.allMetadataFormats = allMetadataFormats;
	}
	
	/**
	 * @return the allTemplatesInfo
	 */
	public List<UITemplateInfo> getAllTemplatesInfo() {
		return allTemplatesInfo;
	}
	
	/**
	 * @param allTemplatesInfo the allTemplatesInfo to set
	 */
	public void setAllTemplatesInfo(List<UITemplateInfo> allTemplatesInfo) {
		this.allTemplatesInfo = allTemplatesInfo;
	}

	/**
	 * @return the allExportPluginsInfo
	 */
	public List<UIExportPluginInfo> getAllExportPluginsInfo() {
		return allExportPluginsInfo;
	}
	/**
	 * @param allExportPluginsInfo the allExportPluginsInfo to set
	 */
	public void setAllExportPluginsInfo(List<UIExportPluginInfo> allExportPluginsInfo) {
		this.allExportPluginsInfo = allExportPluginsInfo;
	}
	public boolean isSelectedMetadataFormatNotInTheAllList() {
		if(metadataFormat == null)
			return false;

		return (allMetadataFormats.indexOf(metadataFormat) == -1);
	}
	
	public boolean isAnySelectedFileLookupKeyNotInTheAllList() {
		for(String selected : fileLookupKeys) {
			if(allFileLookupKeys.indexOf(selected) == -1)
				return true;
		}
		return false;
	}
	
	public UIStatusPlugin getDistUiStatusPlugin() {
		return distUiStatusPlugin;
	}
	
	public void setDistUiStatusPlugin(UIStatusPlugin distUiStatusPlugin) {
		this.distUiStatusPlugin = distUiStatusPlugin;
	}
	
	public UIStatusPlugin getDeplUiStatusPlugin() {
		return deplUiStatusPlugin;
	}
	
	public void setDeplUiStatusPlugin(UIStatusPlugin deplUiStatusPlugin) {
		this.deplUiStatusPlugin = deplUiStatusPlugin;
	}
	
	/**
	 * @return the timerJob
	 */
	public UIJob getTimerJob() {
		return timerJob;
	}
	/**
	 * @param timerJob the timerJob to set
	 */
	public void setTimerJob(UIJob timerJob) {
		this.timerJob = timerJob;
	}
	/**
	 * @return the sitePartner
	 */
	public UISitePartner getSitePartner() {
		return sitePartner;
	}
	/**
	 * @param sitePartner the sitePartner to set
	 */
	public void setSitePartner(UISitePartner sitePartner) {
		this.sitePartner = sitePartner;
	}
	public String getAssociatedGroupName() {
		return associatedGroupName;
	}
	public void setAssociatedGroupName(String associatedGroupName) {
		this.associatedGroupName = associatedGroupName;
	}

}
