package com.ericsson.cms.sites.ui.client.entities;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UISitePartner implements IsSerializable {
	
	private long contextId;
	private String providerId;
	private String lookupKey;
	private UIContact contact;
	private List<UIProperty> properties = new ArrayList<UIProperty>();

	/**
	 * @return the contextId
	 */
	public long getContextId() {
		return contextId;
	}
	/**
	 * @param contextId the contextId to set
	 */
	public void setContextId(long contextId) {
		this.contextId = contextId;
	}
	/**
	 * @return the providerId
	 */
	public String getProviderId() {
		return providerId;
	}
	/**
	 * @param providerId the providerId to set
	 */
	public void setProviderId(String providerId) {
		this.providerId = providerId;
	}
	/**
	 * @return the lookupKey
	 */
	public String getLookupKey() {
		return lookupKey;
	}
	/**
	 * @param lookupKey the lookupKey to set
	 */
	public void setLookupKey(String lookupKey) {
		this.lookupKey = lookupKey;
	}
	/**
	 * @return the contact
	 */
	public UIContact getContact() {
		return contact;
	}
	/**
	 * @param contact the contact to set
	 */
	public void setContact(UIContact contact) {
		this.contact = contact;
	}
	/**
	 * Gets the properties. Will never return null.
	 * 
	 * @return the properties
	 */
	public List<UIProperty> getProperties() {
		return properties;
	}
	/**
	 * Sets properties. Setting null will just clear the properties.
	 * 
	 * @param properties the properties to set
	 */
	public void setProperties(List<UIProperty> properties) {
		if(properties == null)
			this.properties.clear();
		else
			this.properties = properties;
	}
	
	public void addProperty(String name, String value) {
		this.properties.add(new UIProperty(name, value));
	}
}
