package com.ericsson.cms.sites.ui.client.entities;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UISiteTreeNode implements IsSerializable {
	private int id;
	private String name;
	private UISiteType type;
	private String status;
	private boolean active;
	private boolean shared;
	private boolean error;
	private boolean descendantHasError;
	private UISiteTreeNode parent;
	private List<UISiteTreeNode> children = new ArrayList<UISiteTreeNode>();
	
	public UISiteTreeNode() {
		error = false;
		descendantHasError = false;
	}

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the type
	 */
	public UISiteType getType() {
		return type;
	}

	/**
	 * @param type the type to set
	 */
	public void setType(UISiteType type) {
		this.type = type;
	}

	/**
	 * @return the status
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	/**
	 * @return the active
	 */
	public boolean isActive() {
		return active;
	}

	/**
	 * @param active the active to set
	 */
	public void setActive(boolean active) {
		this.active = active;
	}

	/**
	 * @return the shared
	 */
	public boolean isShared() {
		return shared;
	}

	/**
	 * @param shared the shared to set
	 */
	public void setShared(boolean shared) {
		this.shared = shared;
	}

	/**
	 * @return the error flag
	 */
	public boolean isError() {
		return error;
	}

	/**
	 * @param error the error flag to set
	 */
	public void setError(boolean error) {
		this.error = error;
	}

	public boolean isDescendantHasError() {
		return descendantHasError;
	}

	public void setDescendantHasError(boolean descendantHasError) {
		this.descendantHasError = descendantHasError;
	}
	
	/**
	 * @return the children
	 */
	public List<UISiteTreeNode> getChildren() {
		return children;
	}

	/**
	 * Clears the internal list and adds all the given list items.
	 * It is important to note that update of the given list after this method call
	 * will not reflect in the internal list of this object.
	 *  
	 * @param children the children to set
	 */
	public void setChildren(List<UISiteTreeNode> children) {
		this.children.clear();
		if(children != null) {
			for(UISiteTreeNode child : children) {
				addChild(child);
			}
		}
	}

	public boolean hasChildren() {
		return !children.isEmpty();
	}

	public void addChild(UISiteTreeNode child) {
		if(child == null)
			throw new IllegalArgumentException("child cannot be null");
		this.children.add(child);
		child.setParent(this);
	}

	protected void setParent(UISiteTreeNode parent) {
		this.parent = parent;
	}
	
	public UISiteTreeNode getParent() {
		return parent;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + id;
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		UISiteTreeNode other = (UISiteTreeNode) obj;
		if (id != other.id)
			return false;
		return true;
	}
}
