package com.ericsson.cms.sites.ui.client.entities;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UIStatusCount implements IsSerializable {
	private int siteId; //Id of Site being viewed 
	private List<UIStatusCountItem> items = new ArrayList<UIStatusCountItem>();
	private int totalCount;
	
	public UIStatusCount() {
		
	}
	
	public UIStatusCount(int siteId) {
		this.siteId = siteId;
		this.totalCount = 0;
	}

	public int getSiteId() {
		return siteId;
	}

	public void setSiteId(int siteId) {
		this.siteId = siteId;
	}

	public List<UIStatusCountItem> getItems() {
		return items;
	}

	public int getItemCount() {
		if (items != null)
			return items.size();
		else
			return 0;
	}
	
	public List<UIStatusCountItem> getPagedItems(int startIndexForPage, int pageSize) {
		List<UIStatusCountItem> itemsForPage = new ArrayList<UIStatusCountItem>();
		if (items != null) {
			int i= startIndexForPage;
			int last = i+pageSize;
			while ( i<items.size()&& i<last) {
				if (i >= 0)
					itemsForPage.add(items.get(i));
				i++;
			}
		}
		
		return itemsForPage;
	}
	
	public void setItems(List<UIStatusCountItem> items) {
		this.items = items;
	}
	
	public int getTotalCount() {
		return totalCount;
	}

	public void setTotalCount(int totalCount) {
		this.totalCount = totalCount;
	}	
}
