package com.ericsson.cms.sites.ui.client.entities;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITrackingStatus;

public class UIStatusCountItem implements IsSerializable {
	//Maps below is used to look up the index in the list(statusCounts) for each status type 
	private static Map<String, Integer> distStatusIndexLookUp = new LinkedHashMap<String, Integer>();
	private static Map<String, Integer> trackStatusIndexLookUp = new LinkedHashMap<String, Integer>();

	private Long masterTitleId;
	private String masterTitleName;
	//This list contains the aggregated counts for each status type (Distribution & Tracking)
	private List<Integer> statusCounts;
    //metadata for master title
	private List<TitleMetadata> metadata;
	 
	//Table name used to fetch title metadata
	static public String METADATA_TABLE_NAME = "title.AggregatedView.Metadata";
	
	static {
		int index = 0;
		for (UIDistributionStatus status : UIDistributionStatus.values()) {
			distStatusIndexLookUp.put(status.name(), index++);
		}

		for (UITrackingStatus status : UITrackingStatus.values()) {
			trackStatusIndexLookUp.put(status.name(), index++);
		}
	}

	static public Set<String> getStatusNames() {
		return distStatusIndexLookUp.keySet();
	}

	static public Set<String> getTrackStatusNames() {
		return trackStatusIndexLookUp.keySet();
	}

	public UIStatusCountItem() {
		statusCounts = new ArrayList<Integer>();
		for (int i = 0; i < UIDistributionStatus.values().length + UITrackingStatus.values().length; i++) {
			statusCounts.add(0);
		}
	}

	public Long getTitleId() {
		return masterTitleId;
	}

	public void setTitleId(Long titleId) {
		this.masterTitleId = titleId;
	}

	public String getTitleName() {
		return masterTitleName;
	}

	public void setTitleName(String titleName) {
		this.masterTitleName = titleName;
	}

	public Integer getStatusCount(String status) {
		return (statusCounts.get(distStatusIndexLookUp.get(status)));
	}

	public Integer getTrackStatusCount(String status) {
		return (statusCounts.get(trackStatusIndexLookUp.get(status)));
	}
	
	public void setDistStatusCount(String status, int count) {
		int index = distStatusIndexLookUp.get(status);
		statusCounts.set(index, count); 
	}
	
	public void setTrackStatusCount(String status, int count) {
		int index = trackStatusIndexLookUp.get(status);
		statusCounts.set(index, count); 
	}
	
	public List<TitleMetadata> getMetadata() {
		return metadata;
	}
	
	public void setMetadata(List<TitleMetadata> metadata) {
		this.metadata = metadata;
	}
	
}
