/**
 * File Name	:	UIStatusPlugin.java
 * Created		: 	Apr 23, 2010 4:46:44 PM
 * Created By	: 	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Purpose		:	
 *
 * (c) 2010 Ericsson Television Inc.
 */
package com.ericsson.cms.sites.ui.client.entities;

import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * @author esakhat
 *
 */
public class UIStatusPlugin implements IsSerializable {

	private String id;
	private String name;
	private UIStatusPluginType pluginType;
	private Map<String, String> configuration;
	private Map<String, Map<String, String>> multiConfiguration;
	private boolean isLoaded = false;

	/**
	 * 
	 */
	public UIStatusPlugin() {
		super();
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public UIStatusPluginType getPluginType() {
		return pluginType;
	}

	public void setPluginType(UIStatusPluginType pluginType) {
		this.pluginType = pluginType;
	}

	public Map<String, String> getConfiguration() {
		return configuration;
	}

	public void setConfiguration(Map<String, String> configuration) {
		this.configuration = configuration;
	}

	public Map<String, Map<String, String>> getMultiConfiguration() {
		return multiConfiguration;
	}

	public void setMultiConfiguration(
			Map<String, Map<String, String>> multiConfiguration) {
		this.multiConfiguration = multiConfiguration;
	}

	public boolean isLoaded() {
		return isLoaded;
	}

	public void setLoaded(boolean isLoaded) {
		this.isLoaded = isLoaded;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		result = prime * result
				+ ((pluginType == null) ? 0 : pluginType.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		UIStatusPlugin other = (UIStatusPlugin) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		if (pluginType == null) {
			if (other.pluginType != null)
				return false;
		} else if (!pluginType.equals(other.pluginType))
			return false;
		return true;
	}
	
}
