package com.ericsson.cms.sites.ui.client.entities;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UITemplateInfo implements IsSerializable {
	private String templateName;
	private String associatedResourceGroupName;
	//map of variable name to display name
	private Map<String, UITemplateVariable> requiredVariables;
	private boolean isLoaded = true;
	
	public String getTemplateName() {
		return templateName;
	}
	
	public void setTemplateName(String templateName) {
		this.templateName = templateName;
	}
	
	public String getAssociatedResourceGroupName() {
		return associatedResourceGroupName;
	}
	
	public void setAssociatedResourceGroupName(String associatedResourceGroupName) {
		this.associatedResourceGroupName = associatedResourceGroupName;
	}
	
	public Map<String, UITemplateVariable> getRequiredVariables() {
		return requiredVariables;
	}
	
	public void setRequiredVariables(Map<String, UITemplateVariable> requiredVariables) {
		this.requiredVariables = requiredVariables;
	}

	public void addRequiredVariable(String variableName, UITemplateVariable uiTemplateVariable) {
		if(requiredVariables == null)
			requiredVariables = new HashMap<String, UITemplateVariable>();
		requiredVariables.put(variableName, uiTemplateVariable);
	}

	/**
	 * @return the isLoaded
	 */
	public boolean isLoaded() {
		return isLoaded;
	}

	/**
	 * @param isLoaded the isLoaded to set
	 */
	public void setLoaded(boolean isLoaded) {
		this.isLoaded = isLoaded;
	}

	@Override
	public String toString() {
		return getTemplateName() + " | " + getAssociatedResourceGroupName()
				+ " | " + getRequiredVariables();
	}
	
	@Override
	public int hashCode() {
		int prime = 31;
		return prime + ((templateName == null) ? 0 : templateName.hashCode());
	}

	/* 
	 * templateName must be equal for objects of this type to be equal 
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!(obj instanceof UITemplateInfo))
			return false;
		UITemplateInfo other = (UITemplateInfo) obj;
		if (templateName == null)
			return (other.templateName == null);
		return (templateName.equals(other.templateName));
	}
}
