/**
 * File Name	:	TemplateVariable.java
 * Created		: 	May 21, 2010 4:16:52 PM
 * Created By	: 	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Purpose		:	
 *
 * (c) 2010 Ericsson Television Inc.
 */
package com.ericsson.cms.sites.ui.client.entities;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * @author esakhat
 *
 */
public class UITemplateVariable implements IsSerializable {
	
	private String mappedName;
	private UITemplateVariableDataType dataType;
	
	/**
	 * 
	 */
	public UITemplateVariable() {
		super();
	}

	/**
	 * @return the mappedName
	 */
	public String getMappedName() {
		return mappedName;
	}

	/**
	 * @param mappedName the mappedName to set
	 */
	public void setMappedName(String mappedName) {
		this.mappedName = mappedName;
	}

	/**
	 * @return the dataType
	 */
	public UITemplateVariableDataType getDataType() {
		return dataType;
	}

	/**
	 * @param dataType the dataType to set
	 */
	public void setDataType(UITemplateVariableDataType dataType) {
		this.dataType = dataType;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((dataType == null) ? 0 : dataType.hashCode());
		result = prime * result
				+ ((mappedName == null) ? 0 : mappedName.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		UITemplateVariable other = (UITemplateVariable) obj;
		if (dataType == null) {
			if (other.dataType != null)
				return false;
		} else if (!dataType.equals(other.dataType))
			return false;
		if (mappedName == null) {
			if (other.mappedName != null)
				return false;
		} else if (!mappedName.equals(other.mappedName))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "TemplateVariable [dataType=" + dataType + ", mappedName="
				+ mappedName + "]";
	}

	
}
