package com.ericsson.cms.sites.ui.client.entities;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UITitleSiteList implements IsSerializable{
	private int siteId; //Id of Site being viewed 
	String status;
	int count = 0;
	public List<UITitleSiteListItem> items = new ArrayList<UITitleSiteListItem>();
	
	public UITitleSiteList() {

	}

	public UITitleSiteList(int siteId) {
		this();
		setSiteId(siteId);
	}
	
	public int getSiteId() {
		return siteId;
	}
	public void setSiteId(int siteId) {
		this.siteId = siteId;
	}
	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		this.status = status;
	}
	public int getCount() {
		return count;
	}
	public void setCount(int count) {
		this.count = count;
	}
	
	public List<UITitleSiteListItem> getItems() {
		return items;
	}
	
	/**
	 * @return the total number of items (rows)
	 */	
	public int getItemCount() {
		if (items != null)
			return items.size();
		else
			return 0;
	}
	
	/**
	 * @param startIndexForPage the index for 1st item of page
	 * @param pageSize the maximum number of items in one page
	 * @return the items(rows) for one page
	 */		
	public List<UITitleSiteListItem> getPagedItems(int startIndexForPage, int pageSize) {
		List<UITitleSiteListItem> itemsForPage = new ArrayList<UITitleSiteListItem>();
		
		if (items != null) {
			int i= startIndexForPage;
			int last = i+pageSize;
			while ( i<items.size()&& i<last) {
				if (i >= 0)
					itemsForPage.add(items.get(i));
				i++;
			}
		}		
		return itemsForPage;
	}
	
	public void setItems(List<UITitleSiteListItem> items) {
		this.items = items;
	}
}
