/**
 * File Name	:	UiMetadataTree.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Feb 22, 2011 4:17:59 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.entities;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class UiMetadataTree implements IsSerializable {

	private String name;
	private String displayName;
	private String xPath;
	private String fullName;
	private String fullDisplayName;
	private String fullXPath;
	
	private List<UiMetadataTree> children = new ArrayList<UiMetadataTree>();
	
	public UiMetadataTree() {
		this("");
	}

	public UiMetadataTree(String name) {
		super();
		this.name = name;
	}
	
	public boolean isLeaf() {
		return children.size() == 0;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the displayName
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * @param displayName the displayName to set
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	/**
	 * @return the fullName
	 */
	public String getFullName() {
		return fullName;
	}

	/**
	 * @param fullName the fullName to set
	 */
	public void setFullName(String fullName) {
		this.fullName = fullName;
	}

	/**
	 * @return the fullDisplayName
	 */
	public String getFullDisplayName() {
		return fullDisplayName;
	}

	/**
	 * @param fullDisplayName the fullDisplayName to set
	 */
	public void setFullDisplayName(String fullDisplayName) {
		this.fullDisplayName = fullDisplayName;
	}

	/**
	 * @return the children
	 */
	public List<UiMetadataTree> getChildren() {
		return children;
	}

	/**
	 * @param children the children to set
	 */
	public void setChildren(List<UiMetadataTree> children) {
		this.children = children;
	}

	public String getxPath() {
		return xPath;
	}

	public void setxPath(String xPath) {
		this.xPath = xPath;
	}

	public String getFullXPath() {
		return fullXPath;
	}

	public void setFullXPath(String fullXPath) {
		this.fullXPath = fullXPath;
	}

}
