package com.ericsson.cms.sites.ui.client.i18n;

import com.google.gwt.i18n.client.ConstantsWithLookup;

public interface SitesConstants extends ConstantsWithLookup {
	public static final int MAX_LENGTH_SITE_NAME = 50;
	public static final int MAX_LENGTH_SITE_EXTERNAL_ID = 100;
	public static final int MAX_LENGTH_SITE_DESCRIPTION = 255;
	public static final int MIN_VALUE_SITE_ALERT_DELAY_PERIOD = 0;
	public static final int MAX_VALUE_SITE_ALERT_DELAY_PERIOD = Integer.MAX_VALUE;
	
	String labelSitesTreeRoot();
	String noSiteSelected();

	String basicTabName();
	String rulesTabName();
	String jobsTabName();
	String targetedTitlesTabName();

	String basicDisclosurePanelHeading();
	String partnerDisclosurePanelHeading();

	String fieldLabelSiteStatus();
	String fieldLabelName();
	String fieldLabelExternalId();
	String fieldLabelDescription();
	String fieldLabelSiteType();
	String fieldValueSiteTypeLogical();
	String fieldValueSiteTypeDistribution();
	String fieldValueSiteTypeMediaPathDistribution();
	String fieldValueSiteTypeTracking();
	String fieldLabelFileLookupKeys();
	String fieldLabelMetadataFormat();

	String fieldLabelDistOption();
	String fieldValueDistOptionImmediate();
	String fieldValueDistOptionTimed();
	String fieldValueDistOptionManual();
	
	String editTimer();

	String fieldLabelDistConf();
	String fieldLabelExportConf();

	String fieldLabelAlertDelayPeriod();
	String fieldLabelDistStatusPluginPanel();
	String fieldLabelDeplStatusPluginPanel();
	String minutes();
	
	String nameIsRequired();
	String invalidAlertDelayPeriod();
	String nameCannotBeLonger();
	String nameRequiredUnique();
	String externalIdIsRequired();
	String externalIdRequiredUnique();
	String fileLookupKeysIsRequired();
	String metadataFormatIsRequired();
	String distributionOptionIsRequired();
	String distributionConfigurationIsRequired();
	String alertDelayPeriodIsRequired();
	String alertDelayPeriodMustBeInteger();
	String distStatusPluginIsRequired();
	String failedCheckingSiteNameUniqueness();
	String failedCheckingSiteExternalIdUniqueness();
	String associatedResourceIsRequired();
	
	@DefaultIntValue(MAX_LENGTH_SITE_NAME)
	int maxLengthSiteName();
	
	@DefaultIntValue(MAX_LENGTH_SITE_EXTERNAL_ID)
	int maxLengthSiteExternalId();
	
	@DefaultIntValue(MAX_LENGTH_SITE_DESCRIPTION)
	int maxLengthSiteDescription();
	
	@DefaultIntValue(MIN_VALUE_SITE_ALERT_DELAY_PERIOD)
	int minValueSiteAlertDelayPeriod();
	
	@DefaultIntValue(MAX_VALUE_SITE_ALERT_DELAY_PERIOD)
	int maxValueSiteAlertDelayPeriod();
	
	
	String buttonLabelSave();
	String buttonLabelActivate();
	String buttonLabelInactivate();
	String buttonLabelDelete();
	String buttonLabelExport();
	String buttonLabelAdd();
	String buttonLabelDissociate();
	String buttonLabelCreate();
	String buttonLabelCreateChild();
	String buttonLabelAddExisting();
	String buttonLabelYes();
	String buttonLabelNo();
	String buttonLabelOk();
	String buttonLabelCancel();
	
	String menuCreateTopLevelLogicalSite();
	String menuCreateTopLevelDistributionSite();
	String menuCreateChildDistributionSite();
	String menuCreateChildTrackingSite();
	String menuAddExistingTrackingSite();
	String menuDissociateFromParent();
	String menuCreateTopLevelMediapathDistributionSite();
	String menuCreateChildMediapathDistributionSite();

	String captionCreateTopLevelSite();
	String captionCreateChildSite();
	
	String saveSuccessful();
	String activateSuccessful();
	String inactivateSuccessful();
	String deleteSuccessful();
	String exportSuccessful();

	String saveFailed();
	String activateFailed();
	String inactivateFailed();
	String deleteFailed();
	String exportFailed();
	
	String loadingSitesFailed();
	String dissociatingTrackingSiteFailed();
	String loadingAllListsFailed();
	String loadingTrackingSitesFailed();
	String sharingTrackingSitesFailed();
	
	String invalidURL();
	String invalidSiteId();
	String invalidParentSiteId();
	String invalidViewParamValue();
	String unAuthorizedAction();
	
	String unableToVerifyLicense();
	String reachedLicensedMaxDistSites();
	String reachedLicensedMaxTrackingSites();
	
	String confirmRecursiveActivate();
	String confirmRecursiveInactivate();
	String confirmInactivationAsNoTimerJob();
	String confirmTitleDistribution();
	
	String reason();
	
	String dissociatingRuleSetsFailed();
	String dissociatingRuleSetsSucceeded(); 
	String loadingRuleSetsFailed();

	String targetedTitlesTableLabel();
	String goButtonName();
	
	String targeted();
	String ready_for_distribution();
	String in_progress();
	String distributed();
	String failed();

	String deployment_in_progress();
	String deployment_failed();
	String deployed();
	String not_deployed();
	
	String confirmUpdateStatus();
	String updateStatusFailed();
	String updateStatusSuccessful();

	// TODO Remove notify messages once there is api on scheduler backend 
	//		to support site jobs enabling/disabling.
	String notifyJobsMayNeedEnabling();
	String notifyJobsMayNeedDisabling();
	String confirmEnableJobs();
	String enableJobsFailed();
	String enableJobsSuccessful();
	String confirmDisableJobs();
	String disableJobsFailed();
	String disableJobsSuccessful();
	
	String sharedTrackingSiteError();
	String sharedTrackingSiteDisabled();
	String sharedTrackingSite();
	String trackingSiteError();
	String trackingSiteDisabled();
	String trackingSite();
	String distributionSiteError();
	String distributionSiteDisabled();
	String distributionSite();
	String logicalSiteError();
	String logicalSiteDisabled();
	String logicalSite();
	

	String activationTitleNotification();
	
	// Export Status Selection Dialog Constants
	String exportSelectStatusText();
	String all();
	String none();
	String exportNoneSelected();
	
    String componentDisplayName();
    
    // MSO Overrides

    String msoOverridesTabName();
	String msoOverridesHeader();

    // MSO Overrides Table Column Headings
    String columnHeadingField();
    String columnHeadingSearchValue();
    String columnHeadingReplacementValue();
    
    String addButtonText();
    String deleteButtonText();
    String renameButtonText();
    // Save MSO Button
    String saveButtonText();
    String cancelButtonText();
    String saveOverridesButtonText();

    String confirmDeleteSelectedMSO();
	String confirmDissociate();

	String breadCrumbsViewSites();
	String filterListLabel();
	String textLabel();
	String statusLabel();
	String filterButton();
	String clearButton();
	String quickSrchErrorMessage();
}
