package com.ericsson.cms.sites.ui.client.mso;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.ericsson.cms.sites.ui.client.entities.UISite;

import com.ericsson.cms.sites.ui.client.mso.model.UiMso;

import com.ericsson.cms.sites.ui.client.mso.rcp.IMsoViewService;
import com.ericsson.cms.sites.ui.client.mso.rcp.IMsoViewServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;

import com.ericsson.cms.sites.ui.client.Permissions;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class MSOListPanel extends Composite {

	private FlexTableContainer msoTable;
	private IMsoViewServiceAsync viewService;
	private SimplePanel rootPanel;
	private List<UiMso> msoList;
	private UiMso mso;
	private String headerStyle = "mso-t-header";
	private String bodyStyle = "sites.mso.t-body";
	private String listTab = "MSO List";
	private Set<CheckBox> checkBoxSet;
	private AnchorChangeListener anchorChangeListener;

	// widgets used in this view
	private VerticalContainer mainContainer;
	// spacing between the table and message panel
	private static final int SPACING = 2;
	private static final String STYLE_NAME = "content-TitleListsPanel";
	private boolean msoUsedinRules = false;
	private BusyIndicator busyIndicator = new BusyIndicator();
	private ResizableContainer resizableContainer;
	// message panels
	private MessageArea messageArea;
	private HeaderPanel header;

	public MSOListPanel() {

		init();
	}

	private void init() {

		rootPanel = new SimplePanel();
		messageArea = new MessageArea();
		messageArea.reset();
		header = new HeaderPanel("MSO Administration");
		buildComponents();
		this.initWidget(rootPanel);
	}

	public AnchorChangeListener getAnchorChangeListener() {
		return this.anchorChangeListener;
	}

	public void cleanup() {
		this.messageArea.reset();
		mainContainer.clear();
	}

	public void create() {

		MsoCreatePanel createPanel = new MsoCreatePanel(this, false, new UiMso(), msoList);
		mainContainer.add(createPanel);

	}

	public void update(UiMso mso) {

		MsoCreatePanel updatePanel = new MsoCreatePanel(this, true, mso, msoList);
		mainContainer.add(updatePanel);

	}

	public void buildComponents() {
		checkBoxSet = new HashSet<CheckBox>();
		msoTable = new FlexTableContainer();
		msoTable.addStyleName("mso-list-table");
		msoTable.setWidth("100%");
		buildTableHeader(msoTable);
		mainContainer = new VerticalContainer();
		anchorChangeListener = new MsoListAnchorChangeListener(this);
		mainContainer.setSpacing(SPACING);
		mainContainer.addStyleName(STYLE_NAME);

		setResizableContainer(new ResizableContainer(msoTable, listTab, null));

		getResizableContainer().addHeightOffsettingWidget(header);
		getResizableContainer().addHeightOffsettingWidget(messageArea);
		getResizableContainer().setOffsetHeight(10);
		addButtons();
		mainContainer.add(header);
		mainContainer.add(messageArea);
		mainContainer.add(getResizableContainer());

		this.viewService = GWT.create(IMsoViewService.class);
		viewService.getAllMsos(new AsyncCallback<List<UiMso>>() {

			@Override
			public void onFailure(Throwable caught) {
				messageArea.setErrorMessage("Error retrieving mso records: " + caught.getMessage());

			}

			@Override
			public void onSuccess(List<UiMso> result) {
				setMsoList(result);
				buildView(result);
			}

		});

		rootPanel.setWidget(mainContainer);
	}

	public void refresh(String infoMessage) {

		rootPanel.setWidget(null);
		mainContainer.clear();
		if (this.messageArea != null) {
			this.messageArea.reset();
		}
		buildComponents();

	}

	public MessageArea getMessageArea() {
		return messageArea;
	}

	public List<UiMso> getMsoList() {
		return msoList;
	}

	public void setMsoList(List<UiMso> msoList) {
		this.msoList = msoList;
	}

	private void buildView(List<UiMso> result) {
		if (result != null) {
			int row = 1;
			for (UiMso mso : result) {
				setTableRow(msoTable, row, mso);
				row++;
			}
		}
	}

	private void setTableRow(FlexTableContainer msoTable, final int row, final UiMso mso) {
		CheckBox checkBox = new CheckBox();
		checkBox.setFormValue("" + mso.getKey());
		checkBoxSet.add(checkBox);
		msoTable.setWidget(row, 0, checkBox);
		Anchor nameLink = new Anchor(mso.getName());
		msoTable.setWidget(row, 1, nameLink);
		nameLink.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				History.newItem("Sites.Mso.Edit&msoId=" + mso.getKey().toString(), false);
				anchorChanged("Sites.Mso.Edit&msoId=" + mso.getKey().toString());

			}
		});
		msoTable.setWidget(row, 2, new Label(mso.getDescription()));
		List<UISite> siteList = mso.getSiteList();
		String sites = "";
		if (siteList != null) {

			for (UISite site : siteList) {
				if (siteList.indexOf(site) == siteList.size() - 1) {// last one
					sites += site.getName() + " ";
				} else {
					sites += site.getName() + ", ";
				}
			}

		}
		msoTable.setWidget(row, 3, new Label(sites));
		msoTable.getRowFormatter().setStyleName(row, "mso-t-body");
		msoTable.getCellFormatter().setHorizontalAlignment(row, 0, HasAlignment.ALIGN_CENTER);
	}

	private void buildTableHeader(FlexTableContainer msoTable) {
		final CheckBox checkAll = new CheckBox();
		checkAll.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				boolean selected = checkAll.getValue();
				for (CheckBox cb : checkBoxSet) {
					cb.setValue(selected);
				}
			}
		});
		msoTable.setWidget(0, 0, checkAll);
		msoTable.setWidget(0, 1, new LabelWidget("Name"));
		msoTable.setWidget(0, 2, new LabelWidget("Description"));
		msoTable.setWidget(0, 3, new LabelWidget("Sites"));

		msoTable.getRowFormatter().addStyleName(0, headerStyle);

		for (int i = 0; i <= 3; i++) {

			msoTable.getCellFormatter().addStyleName(0, i, "content-AssetContentTable-cell");
			msoTable.getCellFormatter().addStyleName(0, i, "content-AssetContentTable-cell-header");
			Widget widget = msoTable.getWidget(0, i);
			if (widget instanceof LabelWidget) {
				widget.addStyleName("content-AssetContentTable-header-text");

			}
		}
		msoTable.getRowFormatter().addStyleName(0, "content-AssetContentTable-row");
		msoTable.getRowFormatter().addStyleName(0, "content-AssetContentTable-row-header");

	}

	private void addButtons() {
		// New
		ButtonWidget createButton = new ButtonWidget("Create");
		createButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		if (!ClientAuthorizationManager.isAuthorized(Permissions.EDIT)) {
			createButton.setVisible(false);
		}
		createButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				History.newItem("#Sites.Mso.New", false);
				anchorChanged("#Sites.Mso.New");
				// create();
			}
		});

		ButtonWidget deleteButton = new ButtonWidget("Delete");
		deleteButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		if (!ClientAuthorizationManager.isAuthorized(Permissions.EDIT)) {
			deleteButton.setVisible(false);
		}
		deleteButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				final List<Integer> idsToDelete = getIdsToDelete();
				if (messageArea != null) {
					messageArea.reset();
				}
				if (idsToDelete.isEmpty()) {
					messageArea.setInfoMessage("No MSO is selected to delete.");
					getResizableContainer().updateSize();
					return;
				}
				if (!idsToDelete.isEmpty()) {
					
					viewService.getMsoPresentInRules(idsToDelete, new NeptuneAsyncCallback<List<UiMso>>() {

						@Override
						public void onNeptuneFailure(Throwable caught) {

						}

						@Override
						public void onNeptuneSuccess(List<UiMso> result) {
							if (result != null && !result.isEmpty()) {

								if (Window.confirm("MSOs you are trying to delete are used in Rules. Are you sure you want to delete selected MSOs?")) {

									deleteMSOs(idsToDelete);

								}
							} else if (Window.confirm("Are you sure you want to delete selected MSOs?")) {

								deleteMSOs(idsToDelete);

							}

						}

					});

				}
			}

		});

		getResizableContainer().addButton(listTab, createButton);
		getResizableContainer().addButton(listTab, deleteButton);

	}

	private List<Integer> getIdsToDelete() {
		List<Integer> ids = new ArrayList<Integer>();

		for (CheckBox checkBox : checkBoxSet) {
			if (checkBox.getValue()) {
				Integer id = Integer.parseInt(checkBox.getFormValue());
				ids.add(id);
			}
		}

		return ids;
	}

	private void isUsedinRules(List<Integer> idsToDelete) {
		messageArea.reset();
		viewService.getMsoPresentInRules(idsToDelete, new NeptuneAsyncCallback<List<UiMso>>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {

			}

			@Override
			public void onNeptuneSuccess(List<UiMso> result) {
				if (result != null) {
					if (result.isEmpty()) {
						msoUsedinRules = true;
					}
				}

			}

		});

	}

	private void deleteMSOs(List<Integer> selectedIds) {

		messageArea.reset();
		viewService.deleteMsos(selectedIds, new NeptuneAsyncCallback<Void>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				messageArea.setErrorMessage("Delete error: " + caught.getMessage());
				refresh(null);
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				messageArea.setInfoMessage(" MSOs have been successfully deleted");
				refresh(null);

			}

		});

	}

	public void anchorChanged(String anchor) {
		anchorChangeListener.anchorChanged(anchor);

	}

	public void setMso(UiMso mso) {
		this.mso = mso;

	}

	public UiMso getMso() {
		return mso;
	}

	public ResizableContainer getResizableContainer() {
		return resizableContainer;
	}

	public void setResizableContainer(ResizableContainer resizableContainer) {
		this.resizableContainer = resizableContainer;
	}

}
