package com.ericsson.cms.sites.ui.client.mso;

import java.util.List;

import com.ericsson.cms.sites.ui.client.Permissions;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.mso.model.UiMso;
import com.ericsson.cms.sites.ui.client.mso.rcp.IMsoViewService;
import com.ericsson.cms.sites.ui.client.mso.rcp.IMsoViewServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.SimpleListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextAreaWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class MsoCreatePanel extends Composite {

	private AnchorChangeListener anchorChangeListener;
	private VerticalContainer mainPanel;
	private final TextBoxWidget nameTextBox = new TextBoxWidget();
	private TextAreaWidget descriptionTextArea;
	private final FormContainer formContainer; 
	private final int DESCRIPTION_VISIBLE_COUNT = 5;
	private final int DESCRIPTION_CHAR_WIDTH = 40;
	private ResizableContainer resizableContainer;
	private HeaderPanel headerPanel;
	private String createTab = "Create MSO";
	private HorizontalPanel shuffleBox;
	private MessageArea messageArea;
	private IMsoViewServiceAsync viewService;
	private UiMso mso = null;
	private List<UISite> siteList = null;
	private SimpleListBoxWidget rightList;
	private SimpleListBoxWidget leftList;
	List<UiMso> msoList = null;
	private MSOListPanel msoListPanel;
	ButtonWidget saveButton;
	ButtonWidget cancelButton;

	public MsoCreatePanel(MSOListPanel msoListPanel, boolean edit, final UiMso mso, List<UiMso> msoList) {
		
		if (edit) {
			createTab = "Edit MSO";
			headerPanel = new HeaderPanel("MSO Details: " + mso.getName());
		}
		else {
			headerPanel = new HeaderPanel("MSO Administration");
		}
		formContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
		this.msoListPanel = msoListPanel;
		this.msoList = msoList;
		this.mso = mso;
		messageArea = new MessageArea();
		messageArea.reset();
		this.viewService = GWT.create(IMsoViewService.class);

		saveButton = new ButtonWidget("Save");
		saveButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		cancelButton = new ButtonWidget("Cancel");
		cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		
		mainPanel = new VerticalContainer();
		mainPanel.setWidth("100%");

		formContainer.addRow("Name", nameTextBox, true);
		nameTextBox.setMaxLength(255);
		if (mso != null) {
			nameTextBox.setValue(mso.getName());
		}
		nameTextBox.addKeyUpHandler(new KeyUpHandler() {
			@Override
			public void onKeyUp(KeyUpEvent event) {
				mso.setName(nameTextBox.getText());

			}
		});
		descriptionTextArea = new TextAreaWidget();
		descriptionTextArea.getElement().setAttribute("maxlength", "250");
		descriptionTextArea.setCharacterWidth(DESCRIPTION_CHAR_WIDTH);
		descriptionTextArea.setVisibleLines(DESCRIPTION_VISIBLE_COUNT);
		if (mso != null) {
			descriptionTextArea.setValue(mso.getDescription());
		}
		descriptionTextArea.addKeyUpHandler(new KeyUpHandler() {
			@Override
			public void onKeyUp(KeyUpEvent event) {
				mso.setDescription(descriptionTextArea.getText());

			}
		});
		formContainer.addRow("Description", descriptionTextArea, false);
		shuffleBox = createShuffleBox();
		formContainer.addRow("Sites", shuffleBox, false);
		
		resizableContainer = new ResizableContainer(formContainer, createTab, null);
		resizableContainer.addHeightOffsettingWidget(headerPanel);
		resizableContainer.addHeightOffsettingWidget(messageArea);
		resizableContainer.addBottomWidget(createTab, saveButton);
		resizableContainer.addBottomWidget(createTab, cancelButton);
		saveButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				if(!validate()) {
					return;
				}
				saveMso(); 

			}
		});
		cancelButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				cancel();

			}

		});
		if (!ClientAuthorizationManager.isAuthorized(Permissions.EDIT)) {
			saveButton.setVisible(false);
		}
		mainPanel.add(headerPanel);
		mainPanel.add(messageArea);
		mainPanel.add(resizableContainer);

		initWidget(mainPanel);
	}

	private void saveMso() {
		
		msoListPanel.getMessageArea().reset();
		messageArea.reset();
		attachSites(this.mso, rightList );
		viewService.saveMso(mso, new NeptuneAsyncCallback<Void>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				History.newItem("#Sites.MSO", false);
				msoListPanel.cleanup();
				msoListPanel.refresh(null);
				msoListPanel.getMessageArea().setErrorMessage("Save error. " + caught.getMessage());
				
				return;
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				History.newItem("#Sites.MSO", false);
				msoListPanel.cleanup();
				msoListPanel.refresh(null);
				msoListPanel.getMessageArea().setInfoMessage("MSO has been saved successfully");
				msoListPanel.getResizableContainer().updateSize();
			}

		});
			
		
		

	}

	

	private boolean validate( ) {
		boolean check = true;
		if(this.mso.getName() == null || this.mso.getName().trim().isEmpty()) {
			messageArea.setErrorMessage("MSO name cannot be null");
			check = false;
		}
		if(this.mso.getDescription() != null && !this.mso.getDescription().isEmpty()) {
			if(this.mso.getDescription().length() > 255) {
				messageArea.setErrorMessage("MSO Description is too long. Limit is 255 characters. ");
				check = false;
			}
		}
		
		
		
		return check;
	}

	private void attachSites(UiMso mso, SimpleListBoxWidget rightList) {
		mso.setSiteList(null);
		if(rightList != null) {
			for (int i = 0; i<rightList.getItemCount(); i++) {
				String siteName = rightList.getItemText(i);
				UISite uiSite = getUiSiteFromName(siteName);
				if(uiSite != null) {
					mso.addUISite(uiSite);
				}
			}
		}
		
	}

	private UISite getUiSiteFromName(String siteName) {
		
		if(siteList!= null) {
			for(UISite uiSite: siteList) {
				if(uiSite.getName() != null && uiSite.getName().equalsIgnoreCase(siteName)) {
					return uiSite;
				}
			}
		}
		return null;
	}

	public void anchorChanged(String anchor) {
		// anchorChangeListener.anchorChanged(anchor);

	}

	public AnchorChangeListener getAnchorChangeListener() {
		return this.anchorChangeListener;
	}

	public UiMso getMso() {
		return mso;
	}

	public void setMso(UiMso mso) {
		this.mso = mso;
	}

	private void cancel() {
		History.newItem("#Sites.MSO", false);
		msoListPanel.cleanup();
		msoListPanel.refresh(null);

	}

	private HorizontalPanel createShuffleBox() {
		HorizontalPanel shufflePanel = new HorizontalPanel();
		shufflePanel.setStyleName("asset-type-shuffle");

		rightList = new SimpleListBoxWidget(true);
		rightList.setStyleName("asset-type-shuffle-list-box");
		leftList = new SimpleListBoxWidget(true);
		leftList.setStyleName("asset-type-shuffle-list-box");

		ButtonWidget moveRightButton = new ButtonWidget();
		moveRightButton.addStyleName("asset-type-shuffle-button");
		moveRightButton.setText(">");
		moveRightButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				for (int index = leftList.getItemCount() - 1; index >= 0; index--) {
					if (leftList.isItemSelected(index)) {
						int selectedIndex = leftList.getSelectedIndex();
						String siteDisplayName = leftList.getItemText(selectedIndex);
						String siteName = leftList.getValue(selectedIndex);
						leftList.removeItem(selectedIndex);
						rightList.addItem(siteDisplayName, siteName);
					}
				}
			}
		});
		ButtonWidget moveLeftButton = new ButtonWidget();
		moveLeftButton.addStyleName("asset-type-shuffle-button");
		moveLeftButton.setText("<");
		moveLeftButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				for (int index = rightList.getItemCount() - 1; index >= 0; index--) {
					if (rightList.isItemSelected(index)) {
						int selectedIndex = rightList.getSelectedIndex();
						String assetDisplayName = rightList.getItemText(selectedIndex);
						String assetName = rightList.getValue(selectedIndex);
						rightList.removeItem(selectedIndex);
						leftList.addItem(assetDisplayName, assetName);
					}
				}
			}
		});
		VerticalPanel leftListContainer = createListBoxContainer("Not Associated");
		leftListContainer.add(leftList);
		VerticalPanel rightListContainer = createListBoxContainer("Associated");
		rightListContainer.add(rightList);
		VerticalPanel buttonPanel = new VerticalPanel();
		buttonPanel.add(moveRightButton);
		buttonPanel.add(moveLeftButton);

		shufflePanel.add(leftListContainer);
		shufflePanel.add(buttonPanel);
		shufflePanel.add(rightListContainer);
		shufflePanel.setCellVerticalAlignment(buttonPanel, HasVerticalAlignment.ALIGN_MIDDLE);
		shufflePanel.setSpacing(5);

		viewService.getAllSites(new AsyncCallback<List<UISite>>() {

			

			@Override
			public void onFailure(Throwable caught) {
				messageArea.setErrorMessage("Error retrieving mso records: " + caught.getMessage());

			}

			@Override
			public void onSuccess(List<UISite> result) {
				
				siteList = result;
				for (UISite uiSite : result) {
					if (msoContainsSite(uiSite.getId())) {
						rightList.addItem(uiSite.getName());
						
					} else {
						leftList.addItem(uiSite.getName());
					}
				}
			}

		});

		return shufflePanel;
	}

	private VerticalPanel createListBoxContainer(String label) {
		VerticalPanel container = new VerticalPanel();
		container.add(new LabelWidget(label));

		return container;
	}

	private boolean msoContainsSite(Integer id) {
		boolean contains = false;
		if(this.mso.getSiteList() != null) {
			for (UISite site : this.mso.getSiteList()) {
				if (site.getId().equals(id)) {
					contains = true;
					break;
				}
			}
		}

		return contains;
	}

}
