
package com.ericsson.cms.sites.ui.client.mso;



import com.ericsson.cms.sites.ui.client.mso.model.UiMso;
import com.ericsson.cms.sites.ui.client.mso.rcp.IMsoViewService;
import com.ericsson.cms.sites.ui.client.mso.rcp.IMsoViewServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;

public class MsoListAnchorChangeListener implements AnchorChangeListener{
	private static String MSO_LIST_ID = "msoId";
	private static String PARAMETER_DELIMITER = "&";
	private static String VALUE_DELIMITER = "=";
	private final MSOListPanel widget;
	private IMsoViewServiceAsync viewService;
	@Override
	public void anchorChanged(String anchor) {
		Integer msoListId = 0;

		/* Ensure that the widget state is cleaned up */
		widget.cleanup();
		if (anchor != null && anchor.contains("New")) {
			widget.create();

		}
		/* Check for anchor with list id */
		else if (anchor != null && anchor.contains(MSO_LIST_ID)) {
	//		widget.getMsoListTable().reset();

			// skip the first char
			anchor = anchor.substring(1);
			// extract the info from the url
			String[] params = anchor.split(PARAMETER_DELIMITER);
			for (String p : params) {
				String[] paramValue = p.split(VALUE_DELIMITER);
				if (paramValue[0].equalsIgnoreCase(MSO_LIST_ID)) {
					msoListId = Integer.parseInt(paramValue[1]);
				}
			}

			// get the msoList from the server.
			
			if (msoListId == 0) {
				String[] idParams = anchor.split("msoListId=");

				String[] params2 = idParams[1].split(PARAMETER_DELIMITER);
				if (params2[0] != null) {
					msoListId = Integer.parseInt(params2[0]);
				}

			}
			this.viewService = GWT.create(IMsoViewService.class);
			viewService.getMsoById(msoListId, new AsyncCallback<UiMso>() { 

				@Override
				public void onFailure(Throwable caught) {
					widget.getMessageArea().setErrorMessage("Error retrieving mso record: "
							+ caught.getMessage());
					
					
				}

				@Override
				public void onSuccess(UiMso result) {
					UiMso mso = result;
					widget.setMso(mso);
					widget.update(mso);
					
				}
				
			});
			
		} else {
			//widget = null;
		//	widget = new MSOListPanel();
			widget.refresh(null);
		//	widget.getMsoListTable().setAnchor(anchor);
		}
		
	}
	public MsoListAnchorChangeListener(MSOListPanel msoListPanel) {
		this.widget = msoListPanel;
	}

}
