/**
 * File Name	:	IUIMSOOverridesService.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Dec 22, 2011 4:09:59 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import java.util.List;
import java.util.Set;

import com.ericsson.cms.sites.ui.client.entities.UiMetadataTree;
import com.ericsson.cms.sites.ui.client.entities.msooverrides.UIMSOOverridesRequest;
import com.ericsson.cms.sites.ui.client.entities.msooverrides.UIMSOOverridesResponse;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSOOverride;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
@RemoteServiceRelativePath("service/sites/IUIMSOOverridesService")
public interface IUIMSOOverridesService extends RemoteService {
	public List<UIMSO> getMSOs(int siteId) throws NeptuneException;
	public UIMSO saveMSO(int siteId, UIMSO uiMSO) throws NeptuneException;
	public Boolean isMSONameAlreadyUsed(int siteId, String msoName) throws NeptuneException; 
	public void deleteMSO(int msoId) throws NeptuneException;
	public UIMSOOverridesResponse getMSOOverrides(UIMSOOverridesRequest uiMSOOverridesRequest) throws NeptuneException;
	public void saveMSOOverrides(int msoId, List<UIMSOOverride> msoOverrides) throws NeptuneException;
	public void deleteMSOOverrides(Set<Long> overrideIds) throws NeptuneException;
	public UiMetadataTree getMetadataFieldsTree() throws NeptuneException;
}
