/**
 * File Name	:	IUIMSOOverridesServiceAsync.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Dec 22, 2011 4:11:12 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import java.util.List;
import java.util.Set;

import com.ericsson.cms.sites.ui.client.entities.UiMetadataTree;
import com.ericsson.cms.sites.ui.client.entities.msooverrides.UIMSOOverridesRequest;
import com.ericsson.cms.sites.ui.client.entities.msooverrides.UIMSOOverridesResponse;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSOOverride;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public interface IUIMSOOverridesServiceAsync {
	void getMSOs(int siteId, AsyncCallback<List<UIMSO>> callback);
	void saveMSO(int siteId, UIMSO uiMSO, AsyncCallback<UIMSO> callback);
	void isMSONameAlreadyUsed(int siteId, String msoName, AsyncCallback<Boolean> callback);
	void deleteMSO(int msoId, AsyncCallback<Void> callback);
	void getMSOOverrides(UIMSOOverridesRequest uiMSOOverridesRequest, AsyncCallback<UIMSOOverridesResponse> callback);
	void saveMSOOverrides(int msoId, List<UIMSOOverride> msoOverrides, AsyncCallback<Void> callback);
	void deleteMSOOverrides(Set<Long> overrideIds, AsyncCallback<Void> callback);
	void getMetadataFieldsTree(AsyncCallback<UiMetadataTree> callback);
}
