/**
 * File Name	:	MSOOverridesTab.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Dec 31, 2011 11:29:54 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.msooverrides.events.AddEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.AddEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.CancelAddEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.CancelAddEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.CancelMSOAddEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.CancelMSOAddEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.DeleteOverridesEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.DeleteOverridesEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.EmptyMSONameEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.EmptyMSONameEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSOAddedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSOAddedEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSODeletedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSODeletedEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSONameAlreadyUsedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSONameAlreadyUsedEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSORenamedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSORenamedEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.NeptuneFailureEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.NeptuneFailureEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.RemoveOverridesEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.RemoveOverridesEventHandler;
import com.ericsson.cms.sites.ui.client.msooverrides.events.SaveAllOverridesEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.SaveAllOverridesEventHandler;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.events.MSOSelectedEvent;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.events.MSOSelectedEventHandler;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class MSOOverridesPanel extends Composite implements AddEventHandler,
		CancelAddEventHandler, SaveAllOverridesEventHandler,
		DeleteOverridesEventHandler, RemoveOverridesEventHandler,
		MSOAddedEventHandler, MSODeletedEventHandler, MSORenamedEventHandler, 
		MSOSelectedEventHandler, NeptuneFailureEventHandler, 
		MSONameAlreadyUsedEventHandler, EmptyMSONameEventHandler, 
		CancelMSOAddEventHandler {

	interface MyUiBinder extends UiBinder<Widget, MSOOverridesPanel> {}
	private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);
	
	@UiField
	ShowAddDeleteMSOsPanel msosPanel;
	
	@UiField
	DeckPanel overridesPanel;
	
	@UiField
	OverridesListPanel overridesListPanel;
	
	@UiField
	OverridesAddPanel overridesAddPanel;
	
	private IUIMSOOverridesServiceAsync uiMSOOverridesService = GWT.create(IUIMSOOverridesService.class);

	private SitesMessages sitesMessages = GWT.create(SitesMessages.class);

	private final BusyIndicator busyIndicator = new BusyIndicator();

	private UISite uiSite;

	private UIMSO selectedUIMSO;
	
	private MessageArea messageArea;
	
	private int messageAreaOffsetHeight;

	/**
	 * 
	 */
	public MSOOverridesPanel() {
		initWidget(uiBinder.createAndBindUi(this));
		
		msosPanel.setEventBus(MSOOverridesTab.getEventBus());
		
		MSOOverridesTab.getEventBus().addHandler(AddEvent.TYPE, this);
		MSOOverridesTab.getEventBus().addHandler(CancelAddEvent.TYPE, this);
		MSOOverridesTab.getEventBus().addHandler(SaveAllOverridesEvent.TYPE, this);
		MSOOverridesTab.getEventBus().addHandler(DeleteOverridesEvent.TYPE, this);
		MSOOverridesTab.getEventBus().addHandler(RemoveOverridesEvent.TYPE, this);
		MSOOverridesTab.getEventBus().addHandler(MSOAddedEvent.TYPE, this);
		MSOOverridesTab.getEventBus().addHandler(MSODeletedEvent.TYPE, this);
		MSOOverridesTab.getEventBus().addHandler(MSORenamedEvent.TYPE, this);
		MSOOverridesTab.getEventBus().addHandler(MSOSelectedEvent.TYPE, this);
		MSOOverridesTab.getEventBus().addHandler(NeptuneFailureEvent.TYPE, this);
		MSOOverridesTab.getEventBus().addHandler(MSONameAlreadyUsedEvent.TYPE, this);
		MSOOverridesTab.getEventBus().addHandler(EmptyMSONameEvent.TYPE, this);
		MSOOverridesTab.getEventBus().addHandler(CancelMSOAddEvent.TYPE, this);

		overridesPanel.showWidget(0);
	}

	/**
	 * 
	 */
	public MSOOverridesPanel(Map<String, String> info) {
		this();
	}
	
	public void refresh() {
		if (uiSite != null) {
			clearErrorMessage();
			showBusyIndicator();
			uiMSOOverridesService.getMSOs(uiSite.getId(),
					new NeptuneAsyncCallback<List<UIMSO>>() {

						@Override
						public void onNeptuneFailure(Throwable caught) {
							String failureMessage = sitesMessages.errorGettingMSOs(uiSite.getName(), caught.getLocalizedMessage());
							MSOOverridesTab.getEventBus().fireEvent(new NeptuneFailureEvent(failureMessage));
							hideBusyIndicator();
						}

						@Override
						public void onNeptuneSuccess(List<UIMSO> result) {
							setMSOs(result);
							if (result.size() < 1) {
								overridesPanel.setVisible(false);
							}
							else {
								overridesPanel.setVisible(true);
								overridesAddPanel.refresh();
								overridesPanel.showWidget(0);
							}
							if (selectedUIMSO != null) {
								msosPanel.setSelected(selectedUIMSO);
							}
							hideBusyIndicator();
						}

					});
		}
		
	}

	@Override
	public void add(AddEvent event) {
		clearErrorMessage();
		overridesAddPanel.refresh();
		overridesPanel.showWidget(1);
	}

	@Override
	public void cancelAdd(CancelAddEvent event) {
		clearErrorMessage();
		overridesPanel.showWidget(0);
	}
	
	@Override
	public void saveAllOverrides(SaveAllOverridesEvent event) {
		clearErrorMessage();
		overridesListPanel.refresh();
		overridesPanel.showWidget(0);
	}
	
	@Override
	public void deleteOverrides(DeleteOverridesEvent event) {
		clearErrorMessage();
		Collection<Long> overrideIds = event.getOverrideIds();
		if ((overrideIds != null) && (overrideIds.size() > 0)) {
			overridesListPanel.refresh();
			overridesPanel.showWidget(0);
		}
		else {
			String errMsg = sitesMessages.noOverridesSelected();
			showErrorMessage(errMsg);
		}
	}

	@Override
	public void removeOverrides(RemoveOverridesEvent event) {
		clearErrorMessage();
		List<OverrideRow> removedOverrideRows = event.getRemovedOverrideRows();
		if ((removedOverrideRows == null) || (removedOverrideRows.size() < 1)) {
			String errMsg = sitesMessages.noOverridesSelected();
			showErrorMessage(errMsg);
		}
	}

	@Override
	public void msoAdded(MSOAddedEvent event) {
		clearErrorMessage();
		selectedUIMSO = event.getUiMSO();
		refresh();
	}
	
	@Override
	public void msoDeleted(MSODeletedEvent event) {
		clearErrorMessage();
		selectedUIMSO = null;
		refresh();
	}

	@Override
	public void msoRenamed(MSORenamedEvent event) {
		clearErrorMessage();
		selectedUIMSO = event.getUiMSO();
		refresh();
	}

	@Override
	public void msoSelected(MSOSelectedEvent event) {
		clearErrorMessage();
		overridesListPanel.setUiMSO(event.getUiMSO());
		overridesListPanel.refresh();
		overridesAddPanel.setUiMSO(event.getUiMSO());
		overridesAddPanel.refresh();
		
		overridesPanel.showWidget(0);
	}

	@Override
	public void neptuneFailure(NeptuneFailureEvent event) {
		showErrorMessage(event.getFailureMessage());
	}

	@Override
	public void msoNameAlreadyUsed(MSONameAlreadyUsedEvent event) {
		String errMsg = sitesMessages.msoNameAlreadyUsed(event.getMsoName());
		showErrorMessage(errMsg);
	}

	@Override
	public void msoNameEmpty(EmptyMSONameEvent event) {
		String errMsg = sitesMessages.msoNameRequired();
		showErrorMessage(errMsg);
	}

	@Override
	public void msoAddCanceled(CancelMSOAddEvent event) {
		clearErrorMessage();
	}

	public UISite getUiSite() {
		return uiSite;
	}

	public void setUiSite(UISite uiSite) {
		this.uiSite = uiSite;
		msosPanel.setUiSite(uiSite);
	}
	
	/**
	 * @return the messageArea
	 */
	public MessageArea getMessageArea() {
		return messageArea;
	}

	/**
	 * @param messageArea the messageArea to set
	 */
	public void setMessageArea(MessageArea messageArea) {
		this.messageArea = messageArea;
	}

	public void setMSOs(List<UIMSO> uiMSOs) {
		msosPanel.setMSOs(uiMSOs);
	}

	public void updateSize(int offsetWidth, int offsetHeight) {
		msosPanel.msosPanel.updateSize(offsetWidth, offsetHeight);
		overridesListPanel.updateSize(offsetWidth, offsetHeight);
		overridesAddPanel.updateSize(offsetWidth, offsetHeight + 25);
	}
	
	private void showBusyIndicator() {
    	busyIndicator.center();
    }

    private void hideBusyIndicator() {
    	busyIndicator.hide();
    }
    
    private void clearErrorMessage() {
		if (messageArea != null) {
			messageArea.reset();
			int offsetWidth = MSOOverridesTab.MSO_OVERRIDES_PANEL_OFFSET_WIDTH; 
			int offsetHeight = MSOOverridesTab.MSO_OVERRIDES_PANEL_OFFSET_HEIGHT;
			updateSize(offsetWidth, offsetHeight);
		}    	
	}

    private void showErrorMessage(String errMsg) {
		if (messageArea != null) {
			messageArea.setErrorMessage(errMsg);
			updateSizeForMessageArea();
		}    	
	}

	private void updateSizeForMessageArea() {
		messageAreaOffsetHeight = messageArea.getOffsetHeight();
		int overridesListPanelOffsetHeight = overridesListPanel.getOffsetHeight();
		int overridesListPanelOffsetWidth = overridesListPanel.getOffsetWidth();
		int overridesAddPanelOffsetHeight = overridesAddPanel.getOffsetHeight();
		int overridesAddPanelOffsetWidth = overridesAddPanel.getOffsetWidth();
		msosPanel.msosPanel.updateSize(msosPanel.msosPanel.getOffsetWidth(), Window.getClientHeight() - msosPanel.msosPanel.getOffsetHeight() + messageAreaOffsetHeight);
		overridesListPanel.updateSize(Window.getClientWidth() - overridesListPanelOffsetWidth, Window.getClientHeight() - overridesListPanelOffsetHeight + messageAreaOffsetHeight);
		overridesAddPanel.updateSize(Window.getClientWidth() - overridesAddPanelOffsetWidth, Window.getClientHeight() - overridesAddPanelOffsetHeight + messageAreaOffsetHeight);
	}
}
