/**
 * File Name	:	MSOOverridesTab.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Dec 31, 2011 11:29:54 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import java.util.Map;

import com.ericsson.cms.sites.ui.client.Anchors;
import com.ericsson.cms.sites.ui.client.ISiteTab;
import com.ericsson.cms.sites.ui.client.SitesTabContainer.SiteCRUDNotifier;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.entities.UiMetadataTree;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.msooverrides.events.NeptuneFailureEvent;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class MSOOverridesTab extends SimpleContainer implements ISiteTab {
	
	public static final int MSO_OVERRIDES_PANEL_OFFSET_WIDTH = 375;
	public static final int MSO_OVERRIDES_PANEL_OFFSET_HEIGHT = 260;

	private UISite uiSite;

	private static UiMetadataTree metadataTree;

	private IUIMSOOverridesServiceAsync uiMSOOverridesService = GWT.create(IUIMSOOverridesService.class);
	private SitesConstants sitesConstants = GWT.create(SitesConstants.class);
	private SitesMessages sitesMessages = GWT.create(SitesMessages.class);

	private final BusyIndicator busyIndicator = new BusyIndicator();
	
	/**
	 * MSOOverrides panel contains ShowAddDeleteMSOsPanel on left and OverridesPanel on right.
	 * OverridesPanel is a DeckPanel and contains OverridesListPanel and OverridesAddPanel,
	 * one of which is displayed depending on whether user is in list mode 
	 * or in add mode.
	 */
	private MSOOverridesPanel msoOverridesPanel;
		
	private static HandlerManager eventBus;

	private HandlerRegistration windowRegistration = null;

	/**
	 * 
	 */
	public MSOOverridesTab(Map<String, String> info) {
		eventBus = new HandlerManager(this);
		initWidgets();
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {
			@Override
			public void execute() {
				updateSize();
			}
		});
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.sites.ui.client.ISiteTab#getName()
	 */
	@Override
	public String getName() {
		return "MSO Overrides";
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.sites.ui.client.ISiteTab#getDisplayName()
	 */
	@Override
	public String getDisplayName() {
		return sitesConstants.msoOverridesTabName();
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.sites.ui.client.ISiteTab#setSite(com.ericsson.cms.sites.ui.client.entities.UISite, java.util.Map)
	 */
	@Override
	public boolean setSite(UISite site, Map<String, String> params) {
		boolean retVal = false;
		
		if (site != null) {
			this.setUiSite(site);
			
			UISiteType uiSiteType = uiSite.getType();
			if (UISiteType.MEDIAPATH_DISTRIBUTION.equals(uiSiteType)) {
				retVal = true;
			}
			
		}
		
		return retVal;
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.sites.ui.client.ISiteTab#setCRUDNotifier(com.ericsson.cms.sites.ui.client.SitesTabContainer.SiteCRUDNotifier)
	 */
	@Override
	public void setCRUDNotifier(SiteCRUDNotifier crudNotifier) {
	}

	/* (non-Javadoc)
	 * @see com.ericsson.cms.sites.ui.client.ISiteTab#setSelected(boolean)
	 */
	@Override
	public void setSelected(boolean selected) {
		if (selected && (uiSite != null)) {
			History.newItem(Anchors.getAnchor(uiSite.getId(), uiSite.getParentId(), getName()), false);
			loadMetadataTree();
		}
	}

	public UISite getUiSite() {
		return uiSite;
	}

	public void setUiSite(UISite uiSite) {
		this.uiSite = uiSite;
		msoOverridesPanel.setUiSite(uiSite);
	}

	private void initWidgets() {
		VerticalContainer mainPanel = new VerticalContainer();
		mainPanel.setWidth("100%");
		// MSO Overrides Panel
		msoOverridesPanel = new MSOOverridesPanel();
		mainPanel.add(msoOverridesPanel);
		
		setWidget(mainPanel);
	}
	
    public static HandlerManager getEventBus() {
		return eventBus;
	}

	public static void setEventBus(HandlerManager eventBus) {
		MSOOverridesTab.eventBus = eventBus;
	}

	public static UiMetadataTree getMetadataTree() {
		return metadataTree;
	}

	public static void setMetadataTree(UiMetadataTree metadataTree) {
		MSOOverridesTab.metadataTree = metadataTree;
	}

	private void loadMetadataTree() {
		showBusyIndicator();
		uiMSOOverridesService.getMetadataFieldsTree(new NeptuneAsyncCallback<UiMetadataTree>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				hideBusyIndicator();
				String failureMessage = sitesMessages.errorGettingMetadataTree(caught.getLocalizedMessage());
				MSOOverridesTab.getEventBus().fireEvent(new NeptuneFailureEvent(failureMessage));
			}

			@Override
			public void onNeptuneSuccess(UiMetadataTree result) {
				metadataTree = result;
				MetadataFieldWidget.setMetadataSelector(null);
				MetadataFieldWidget.setHandlerRegistration(null);
				msoOverridesPanel.refresh();
				hideBusyIndicator();
			}

		});
	}

	private void showBusyIndicator() {
    	busyIndicator.center();
    }

    private void hideBusyIndicator() {
    	busyIndicator.hide();
    }

	@Override
	public void setMessageArea(MessageArea messageArea) {
		if (msoOverridesPanel != null) {
			msoOverridesPanel.setMessageArea(messageArea);
		}
	}
	
	void updateSize() {
		int offsetWidth = MSO_OVERRIDES_PANEL_OFFSET_WIDTH; 
		int offsetHeight = MSO_OVERRIDES_PANEL_OFFSET_HEIGHT;
		
		msoOverridesPanel.updateSize(offsetWidth, offsetHeight);
	}

	// ==============================================================
	// ===================== WIDGET OVERRIDES
	// ==============================================================

	@Override
	protected void onLoad() {
		super.onLoad();

		windowRegistration = Window.addResizeHandler(new ResizeHandler() {
			public void onResize(ResizeEvent event) {
				updateSize();
			}
		});
	};

	@Override
	protected void onUnload() {
		windowRegistration.removeHandler();
		windowRegistration = null;

		if (busyIndicator != null)
			busyIndicator.hide();

		super.onUnload();
	}

}
