/**
 * File Name	:	MSOOverridesUtils.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Feb 29, 2012 5:41:38 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.msooverrides.events.NeptuneFailureEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.SaveAllOverridesEvent;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSOOverride;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class MSOOverridesUtils {

	private final BusyIndicator busyIndicator = new BusyIndicator();

	private IUIMSOOverridesServiceAsync uiMSOOverridesService = GWT.create(IUIMSOOverridesService.class);

	private SitesMessages sitesMessages = GWT.create(SitesMessages.class);

	/**
	 * 
	 */
	public MSOOverridesUtils() {
		super();
	}

	public void saveAllOverrides(UIMSO uiMSO, List<OverrideRow> overrideRows) {
		if ((uiMSO != null) && (overrideRows != null) && (overrideRows.size() > 0)) {
			MSOOverridesUtils msoOverridesUtils = new MSOOverridesUtils();
			List<UIMSOOverride> uiMSOOverrides = msoOverridesUtils.getUIMSOOverrides(overrideRows);
			boolean areMSOOverridesValid = msoOverridesUtils.areMSOOverridesValid(uiMSOOverrides);
			if (areMSOOverridesValid) {
				int msoId = uiMSO.getMsoId();
				saveMSOOverrides(msoId, uiMSOOverrides);
			}
			else {
				// TODO Define a new ShowErrorEvent
				String errMsg = sitesMessages.cannotSaveEmptyValues();
				MSOOverridesTab.getEventBus().fireEvent(
						new NeptuneFailureEvent(errMsg));
			}
		}

	}
	
	public List<UIMSOOverride> getUIMSOOverrides(List<OverrideRow> overrideRows) {
		List<UIMSOOverride> uiMSOOverrides = null;
		if (overrideRows != null) {
			uiMSOOverrides = new ArrayList<UIMSOOverride>();
			if (overrideRows.size() > 0) {
				for (OverrideRow overrideRow : overrideRows) {
					UIMSOOverride uiMSOOverride = new UIMSOOverride();
					uiMSOOverride.setOverrideId(overrideRow.getOverrideId());
					uiMSOOverride.setFieldXPath(overrideRow.getMfwFieldXPath()
							.getValue());
					uiMSOOverride.setSearchValue(overrideRow
							.getTxtSearchValue().getText());
					uiMSOOverride.setReplacementValue(overrideRow
							.getTxtReplacementValue().getText());

					uiMSOOverrides.add(uiMSOOverride);
				}
			}
		}
		
		return uiMSOOverrides;
	}
	
	public void saveMSOOverrides(final int msoId, List<UIMSOOverride> uiMSOOverrides) {
		showBusyIndicator();
		uiMSOOverridesService.saveMSOOverrides(msoId, uiMSOOverrides, new NeptuneAsyncCallback<Void>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				String failureMessage = sitesMessages.errorSavingOverrides(msoId, caught.getLocalizedMessage());
				MSOOverridesTab.getEventBus().fireEvent(new NeptuneFailureEvent(failureMessage));
				hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				MSOOverridesTab.getEventBus().fireEvent(new SaveAllOverridesEvent());
				hideBusyIndicator();
			}
			
		});		
	}
	
	public boolean areMSOOverridesValid(List<UIMSOOverride> uiMsoOverrides) {
		boolean areMSOOverridesValid = false;
		
		for (UIMSOOverride uiMSOOverride : uiMsoOverrides) {
			areMSOOverridesValid = isValid(uiMSOOverride);
			if (!areMSOOverridesValid) {
				break;
			}
		}
		return areMSOOverridesValid;
	}
	
	public boolean isValid(UIMSOOverride uiMsoOverride) {
		boolean isValid = false;
		String fieldXPath = uiMsoOverride.getFieldXPath();
		String searchValue = uiMsoOverride.getSearchValue();
		String replacementValue = uiMsoOverride.getReplacementValue();
		
		isValid = isValidFieldXPath(fieldXPath)
				&& isValidSearchValue(searchValue)
				&& isValidReplacementValue(replacementValue);
		
		return isValid;
	}	
	
	public boolean isValidFieldXPath(String fieldXPath) {
		return (fieldXPath != null) && (!fieldXPath.trim().isEmpty()) && (fieldXPath.contains("/Fields"));
	}

	public boolean isValidSearchValue(String searchValue) {
		return (searchValue != null) && (!searchValue.isEmpty());
	}
	
	public boolean isValidReplacementValue(String replacementValue) {
		return (replacementValue != null) && (!replacementValue.isEmpty());
	}

	private void showBusyIndicator() {
    	busyIndicator.center();
    }

    private void hideBusyIndicator() {
    	busyIndicator.hide();
    }
	
}
