/**
 * File Name	:	MetadatFieldWidget.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Feb 17, 2011 12:55:08 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import com.ericsson.cms.sites.ui.client.entities.UiMetadataTree;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class MetadataFieldWidget extends Composite {

	private static final String FULL_DISPLAY_NAME_PREFIX = "";

	String value;
	SimpleContainer container;
	TextBoxWidget textBox;
	private static MetadataSelector metadataSelector;
	private static HandlerRegistration handlerRegistration; 
	boolean editable = false;
		
	/**
	 * 
	 */
	public MetadataFieldWidget() {
		super();

		container = new SimpleContainer();
		container.setWidth("100%");
		initWidget(container);
		textBox = new TextBoxWidget();
		container.add(textBox);
		
		if (metadataSelector == null) {
			metadataSelector = new MetadataSelector(
					MSOOverridesTab.getMetadataTree(), !editable, null);
		}
		
		textBox.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				if (handlerRegistration != null) {
					handlerRegistration.removeHandler();
				}
				handlerRegistration = metadataSelector.addSelectionHandler(getSelectionHandler());

				int x = textBox.getAbsoluteLeft();
				int y = textBox.getAbsoluteTop();
				metadataSelector.show(x, y);
				metadataSelector.setSelectedItem(value);
			}
			
			private SelectionHandler<UiMetadataTree> getSelectionHandler() {
				return new SelectionHandler<UiMetadataTree>() {

					@Override
					public void onSelection(SelectionEvent<UiMetadataTree> event) {
						UiMetadataTree metadataNode = event.getSelectedItem();
						textBox.setText(FULL_DISPLAY_NAME_PREFIX
								+ metadataNode.getFullDisplayName());
						value = metadataNode.getFullXPath();
					}
					
				};
			}

			
		});

	}
	
	/**
	 * @param length
	 * @see com.google.gwt.user.client.ui.TextBox#setVisibleLength(int)
	 */
	public void setVisibleLength(int length) {
		textBox.setVisibleLength(length);
	}

	/**
	 * @return
	 * @see com.google.gwt.user.client.ui.TextBoxBase#getText()
	 */
	public String getText() {
		return textBox.getText();
	}

	/**
	 * @param text
	 * @see com.google.gwt.user.client.ui.TextBoxBase#setText(java.lang.String)
	 */
	public void setText(String text) {
		textBox.setText(text);
	}
	
	public void setEditable(boolean editable) {
		this.editable = editable;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value the value to set
	 */
	public void setValue(String value) {
		this.value = value;
		resolveTextBox();
	}
	
	/**
	 * 
	 * @param enabled
	 */
	public void setEnabled(boolean enabled) {
		textBox.setEnabled(enabled);
	}

	private void resolveTextBox() {
		setText(resolveDisplayName());
	}
	
	private String resolveDisplayName() {
		String fullDisplayName = null;
		
		if (value != null) {
			String fullXPath = value;
			UiMetadataTree foundNode = findNodeByFullXPath(fullXPath);
			if (foundNode != null) {
				fullDisplayName = foundNode.getFullDisplayName();
			}
		}
		
		return fullDisplayName;
	}
	
	private UiMetadataTree findNodeByFullXPath(String fullXPath) {
		UiMetadataTree foundNode = null;

		foundNode = findNodeByFullXPath(MSOOverridesTab.getMetadataTree(), fullXPath);
		
		return foundNode;
	}
	
	private UiMetadataTree findNodeByFullXPath(UiMetadataTree uiMetadataTree, String fullXPath) {
		UiMetadataTree foundNode = null;
		if (uiMetadataTree != null) {
			for (UiMetadataTree node : uiMetadataTree.getChildren()) {
				if (fullXPath.equals(node.getFullXPath())) {
					foundNode = node;
					break;
				}
				foundNode = findNodeByFullXPath(node, fullXPath);
				if (foundNode != null) {
					break;
				}
			}
		}
		
		return foundNode;
	}

	@Override
	public void setWidth(String width) {
		textBox.setWidth(width);
	}

	public void setFocus(boolean focused) {
		textBox.setFocus(focused);
	}
	
	/**
	 * @return the metadataSelector
	 */
	public static MetadataSelector getMetadataSelector() {
		return metadataSelector;
	}

	/**
	 * @param metadataSelector the metadataSelector to set
	 */
	public static void setMetadataSelector(MetadataSelector metadataSelector) {
		MetadataFieldWidget.metadataSelector = metadataSelector;
	}

	/**
	 * @return the handlerRegistration
	 */
	public static HandlerRegistration getHandlerRegistration() {
		return handlerRegistration;
	}

	/**
	 * @param handlerRegistration the handlerRegistration to set
	 */
	public static void setHandlerRegistration(
			HandlerRegistration handlerRegistration) {
		MetadataFieldWidget.handlerRegistration = handlerRegistration;
	}

}
