/**
 * File Name	:	MetadataSelector.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Feb 22, 2011 4:48:46 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.ericsson.cms.sites.ui.client.entities.UiMetadataTree;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;

/**
 * A popup for selecting Metadata Fields, given a metadata field tree 
 * represented by {@link UiMetadataTree}.
 * 
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class MetadataSelector extends PopupContainer implements HasSelectionHandlers<UiMetadataTree> {
	private static final int BOX_HEIGHT_INT = 200;

	private ScrollPanel scrollPanel = new ScrollPanel();
	private Tree tree;

	private int currentPosition = 0;
	private Timer timer;
	private List<HandlerRegistration> currentHackHandlers = new ArrayList<HandlerRegistration>();

	/**
	 * 
	 * @param metadataTree
	 * @param modal
	 */
	public MetadataSelector(UiMetadataTree metadataTree, boolean modal) {
		super(true, modal);
		
		timer = new Timer() {
			public void run() {
				scrollPanel.setScrollPosition(currentPosition);
			}
		};

		buildTree(metadataTree);
		tree.getItem(0).setState(true, false);
		tree.addSelectionHandler(new SelectionHandler<TreeItem>() {

			@Override
			public void onSelection(SelectionEvent<TreeItem> event) {
				TreeItem treeItem = event.getSelectedItem();
				if (treeItem.getUserObject() != null) {
					UiMetadataTree metadataTree = (UiMetadataTree) treeItem
							.getUserObject();
					List<UiMetadataTree> childrenUiMetadataTree = metadataTree.getChildren();
					if ((childrenUiMetadataTree == null) || (childrenUiMetadataTree.size() < 1)) {
						SelectionEvent
								.fire(MetadataSelector.this, metadataTree);
						hide();
					}
				}
			}

		});
		scrollPanel.setSize("275px", "200px");
		scrollPanel.setWidget(tree);
		addScrollHack(tree);
		setWidget(scrollPanel);
	}
	
	/**
	 * If <code>fullXPath</code> parameter is provided, finds the {@link TreeItem} 
	 * containing the {@link UiMetadataTree} node representing that 
	 * <code>fullXPath</code>, and selects that {@link TreeItem}.
	 *  
	 * @param metadataTree
	 * @param modal
	 * @param fullXPath
	 */
	public MetadataSelector(UiMetadataTree metadataTree, boolean modal, String fullXPath) {
		this(metadataTree, modal);
		if ((fullXPath != null) && !(fullXPath.isEmpty())) {
			setSelectedItem(fullXPath);
		}
	}
	
	@Override
	public HandlerRegistration addSelectionHandler(
			SelectionHandler<UiMetadataTree> handler) {
		return addHandler(handler, SelectionEvent.getType());
	}
		
	public void show(final int x, final int y) {
		setPopupPositionAndShow(new PopupPanel.PositionCallback() {
			public void setPosition(int offsetWidth, int offsetHeight) {
				int height = Window.getClientHeight();
				int yOffset = 0;
				if (y + BOX_HEIGHT_INT > height)
					yOffset = BOX_HEIGHT_INT + 30;
				setPopupPosition(x, y - yOffset);
			}
		});
	}

	/**
	 * finds the {@link TreeItem} containing the {@link UiMetadataTree} 
	 * node representing the given <code>fullXPath</code> and selects that 
	 * {@link TreeItem}.
	 * 
	 * @param fullXPath
	 */
	public void setSelectedItem(String fullXPath) {
		TreeItem treeItem = findTreeItem(tree, fullXPath);
		if (treeItem != null) {
			tree.setSelectedItem(treeItem, false);
			tree.ensureSelectedItemVisible();
			scrollPanel.ensureVisible(treeItem);
		}
	}
	
	private TreeItem findTreeItem(Tree tree, String fullXPath) {
		TreeItem foundTreeItem = null;
		
		if ((tree != null) && (fullXPath != null)) {
			Iterator<TreeItem> treeItemIterator = tree.treeItemIterator();
			while (treeItemIterator.hasNext()) {
				TreeItem treeItem = treeItemIterator.next();
				if (treeItem.getUserObject() != null) {
					UiMetadataTree uiMetadataTree = (UiMetadataTree) treeItem.getUserObject();
					String mtFullXPath = uiMetadataTree.getFullXPath();
					if (fullXPath.equals(mtFullXPath)) {
						foundTreeItem = treeItem;
						break;
					}
				}
			}
		}
		
		return foundTreeItem;
	}
		
	private void buildTree(UiMetadataTree metadataTree) {
		tree = new TreeWidget();
		if (metadataTree != null) {
			if (metadataTree.getName().isEmpty()) {
				for (UiMetadataTree node : metadataTree.getChildren()) {
					TreeItem item = new TreeItem(node.getDisplayName());
					item.setUserObject(node);
					addNodes(item, node.getChildren());
					tree.addItem(item);
				}
			} else {
				TreeItem item = new TreeItem(metadataTree.getDisplayName());
				item.setUserObject(metadataTree);
				addNodes(item, metadataTree.getChildren());
				tree.addItem(item);
			}
		}
	}
	
	private void addNodes(TreeItem item, List<UiMetadataTree> nodes) {
		for (UiMetadataTree node : nodes) {
			if (node != null) {
				TreeItem childItem = new TreeItem(node.getDisplayName());
				childItem.setUserObject(node);
				addNodes(childItem, node.getChildren());
				item.addItem(childItem);
			}
		}
	}
	
	/*
	 * this is to fix that bloody hack that moves the wheel back and forth
	 */
	private void addScrollHack(Tree currentTree) {
		for (HandlerRegistration r : currentHackHandlers) {
			r.removeHandler();
		}
		currentHackHandlers.clear();

		currentHackHandlers.add(currentTree
				.addMouseDownHandler(new MouseDownHandler() {
					@Override
					public void onMouseDown(MouseDownEvent event) {
						currentPosition = scrollPanel.getScrollPosition();
					}
				}));

		currentHackHandlers.add(currentTree
				.addMouseUpHandler(new MouseUpHandler() {
					@Override
					public void onMouseUp(MouseUpEvent event) {
						timer.schedule(5);
					}
				}));
	}

}
