/**
 * File Name	:	OverrideRowsTable.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jan 3, 2012 11:14:01 AM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.ericsson.cms.sites.ui.client.Permissions;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.msooverrides.events.DeleteOverridesEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.NeptuneFailureEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.RemoveOverridesEvent;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSOOverride;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class OverrideRowsPanel extends Composite {
	interface MyUiBinder extends UiBinder<Widget, OverrideRowsPanel> {}
	private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);
	
	@UiField
	protected FlexTable overridesTable;
	
	protected List<OverrideRow> overrideRows;

	private final BusyIndicator busyIndicator = new BusyIndicator();

	private IUIMSOOverridesServiceAsync uiMSOOverridesService = GWT.create(IUIMSOOverridesService.class);

	private SitesConstants sitesConstants = GWT.create(SitesConstants.class);
	private SitesMessages sitesMessages = GWT.create(SitesMessages.class);

	private NeptuneSecurity security;

	/**
	 * 
	 */
	public OverrideRowsPanel() {
		initWidget(uiBinder.createAndBindUi(this));

		security = NeptuneApplication.getApplication().getSecurity();
	}
	
	public List<UIMSOOverride> getUIMSOOverrides() {
		MSOOverridesUtils msoOverridesUtils = new MSOOverridesUtils();
		return msoOverridesUtils.getUIMSOOverrides(overrideRows);
	}
	
	public void setUIMSOOverrides(List<UIMSOOverride> uiMSOOverrides) {
		overrideRows = generateOverrideRows(uiMSOOverrides);
		setOverrideRowsToTable(overrideRows);
	}

	public void addOverrideRow(OverrideRow overrideRow) {
		if (overrideRows == null) {
			overrideRows = new ArrayList<OverrideRow>();
		}
		overrideRows.add(overrideRow);
	}
	
	public void saveAllOverrides(UIMSO uiMSO) {
		MSOOverridesUtils msoOverridesUtils = new MSOOverridesUtils();
		msoOverridesUtils.saveAllOverrides(uiMSO, overrideRows);
	}
	
	public void deleteSelected() {
		Set<Long> selectedIds = getSelectedIds();
		delete(selectedIds);
	}
	
	public void removeSelected() {
		removeSelectedFromView();
	}
	
	public void resetFocus(boolean focused) {
		if ((overrideRows != null) && (!overrideRows.isEmpty())) {
			OverrideRow firstOverrideRow = overrideRows.get(0);
			firstOverrideRow.setFocus(focused);
		}
	}

	protected List<OverrideRow> generateOverrideRows(List<UIMSOOverride> uiMSOOverrides) {
		List<OverrideRow> overrideRows = null;
		
		if (uiMSOOverrides != null) {
			overrideRows = new ArrayList<OverrideRow>();
			for (UIMSOOverride uiMSOOverride : uiMSOOverrides) {
				OverrideRow overrideRow = new OverrideRow();
				overrideRow.setOverrideId(uiMSOOverride.getOverrideId());
				overrideRow.getMfwFieldXPath().setValue(uiMSOOverride.getFieldXPath());
				overrideRow.getTxtSearchValue().setText(uiMSOOverride.getSearchValue());
				overrideRow.getTxtReplacementValue().setText(uiMSOOverride.getReplacementValue());
				
				overrideRows.add(overrideRow);
			}
		}
		
		return overrideRows;
	}
	
	protected void setOverrideRowsToTable(final List<OverrideRow> overrideRows) {
		
		overridesTable.removeAllRows();
		overridesTable.setWidth("100%");
		
		overridesTable.getRowFormatter().addStyleName(0, "sites-msooverridesList-header");
		
		int row = 0;
		
		final CheckBoxWidget allCB = new CheckBoxWidget();
		if (security.isUserInRole(Permissions.EDIT)) {
			allCB.addValueChangeHandler(new ValueChangeHandler<Boolean>() {

				@Override
				public void onValueChange(ValueChangeEvent<Boolean> event) {
					if (overrideRows != null) {
						for (OverrideRow overrideRow : overrideRows) {
							overrideRow.getCheckBox().setValue(event.getValue(), true);
						}
					}
					
				}
				
			});
		}
		else {
			allCB.setEnabled(false);
		}
		overridesTable.setWidget(row, 0, allCB);
		overridesTable.setText(row, 1, sitesConstants.columnHeadingField());
		overridesTable.setText(row, 2, sitesConstants.columnHeadingSearchValue());
		overridesTable.setText(row, 3, sitesConstants.columnHeadingReplacementValue());
		
		overridesTable.getCellFormatter().setWidth(row, 0, "4%");
		overridesTable.getCellFormatter().setWidth(row, 1, "45%");
		overridesTable.getCellFormatter().setWidth(row, 2, "25%");
		overridesTable.getCellFormatter().setWidth(row, 3, "25%");
		
		
		if (overrideRows != null) {
			for (OverrideRow overrideRow : overrideRows) {
				row++;
				addOverrideRowToTable(row, overrideRow);
			}
		}
	}

	protected void addOverrideRowToTable(int row, OverrideRow overrideRow) {
			
		overridesTable.getRowFormatter().addStyleName(row,
				"sites-msooverridesList-data");
		overridesTable.setWidget(row, 0, overrideRow.getCheckBox());
		overridesTable.setWidget(row, 1, overrideRow.getMfwFieldXPath());
		overridesTable.setWidget(row, 2, overrideRow.getTxtSearchValue());
		overridesTable.setWidget(row, 3, overrideRow.getTxtReplacementValue());
		
		if (!security.isUserInRole(Permissions.EDIT)) {
			overrideRow.getCheckBox().setEnabled(false);
			overrideRow.getMfwFieldXPath().setEnabled(false);
			overrideRow.getTxtSearchValue().setEnabled(false);
			overrideRow.getTxtReplacementValue().setEnabled(false);
		}
		
		overridesTable.getCellFormatter().setAlignment(row, 0,
				HasHorizontalAlignment.ALIGN_CENTER,
				HasVerticalAlignment.ALIGN_MIDDLE);
		overridesTable.getCellFormatter().setAlignment(row, 1,
				HasHorizontalAlignment.ALIGN_CENTER,
				HasVerticalAlignment.ALIGN_MIDDLE);
		overridesTable.getCellFormatter().setAlignment(row, 2,
				HasHorizontalAlignment.ALIGN_CENTER,
				HasVerticalAlignment.ALIGN_MIDDLE);
		overridesTable.getCellFormatter().setAlignment(row, 3,
				HasHorizontalAlignment.ALIGN_CENTER,
				HasVerticalAlignment.ALIGN_MIDDLE);
		
	}
	
	protected void delete(final Set<Long> overrideIds) {
		showBusyIndicator();
		if ((overrideIds != null) && (overrideIds.size() > 0)) {
			uiMSOOverridesService.deleteMSOOverrides(overrideIds, new NeptuneAsyncCallback<Void>() {

				@Override
				public void onNeptuneFailure(Throwable caught) {
					hideBusyIndicator();
					String failureMessage = sitesMessages.errorDeletingOverrides(caught.getLocalizedMessage());
					MSOOverridesTab.getEventBus().fireEvent(new NeptuneFailureEvent(failureMessage));
				}

				@Override
				public void onNeptuneSuccess(Void result) {
					MSOOverridesTab.getEventBus().fireEvent(new DeleteOverridesEvent(overrideIds));					
					hideBusyIndicator();
				}
				
			});
		}
	}
	
	protected void removeSelectedFromView() {
		Iterator<OverrideRow> overrideRowsIterator = overrideRows.iterator();
		List<OverrideRow> removedOverrideRows = new ArrayList<OverrideRow>();
		while (overrideRowsIterator.hasNext()) {
			OverrideRow overrideRow = overrideRowsIterator.next();
			boolean checked = overrideRow.getCheckBox().getValue();
			if (checked) {
				removedOverrideRows.add(overrideRow);
				overrideRowsIterator.remove();
			}
		}
		setOverrideRowsToTable(overrideRows);
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {
			public void execute() {
				resetFocus(true);
			}
		});
		MSOOverridesTab.getEventBus().fireEvent(new RemoveOverridesEvent(removedOverrideRows));					
	}
	
	protected Set<Long> getSelectedIds() {
		List<OverrideRow> selectedRows = getSelectedRows();
		Set<Long> selectedIds = new HashSet<Long>(selectedRows.size());
		for (OverrideRow overrideRow : selectedRows) {
			Long overrideId = overrideRow.getOverrideId();
			if (overrideId != null) {
				selectedIds.add(overrideId);
			}
		}
		return selectedIds;
	}
	
	protected List<OverrideRow> getSelectedRows() {
		List<OverrideRow> selectedRows = new ArrayList<OverrideRow>();
		for (OverrideRow overrideRow : overrideRows) {
			boolean checked = overrideRow.getCheckBox().getValue();
			if (checked) {
				selectedRows.add(overrideRow);
			}
		}
		
		return selectedRows;
	}
	
	private void showBusyIndicator() {
    	busyIndicator.center();
    }

    private void hideBusyIndicator() {
    	busyIndicator.hide();
    }
	
}
