/**
 * File Name	:	OverridesLisPanel.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Dec 25, 2011 6:35:14 AM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.sites.ui.client.Permissions;
import com.ericsson.cms.sites.ui.client.msooverrides.events.CancelAddEvent;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSOOverride;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class OverridesAddPanel extends Composite {

	interface MyUiBinder extends UiBinder<Widget, OverridesAddPanel> {}
	private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);

	@UiField
	ScrollPanel scrollPanel;

	@UiField
	OverrideRowsPanel overrideRowsPanel;
	
	@UiField
	HorizontalPanel buttonsPanel;

	@UiField
	Button btnAddMore;
	
	@UiField
	Button btnSaveAllOverrides;

	@UiField
	Button btnDelete;

	@UiField
	Button btnCancel;
	
	private UIMSO uiMSO;
	
	private int numRows;
		
	private NeptuneSecurity security;

	/**
	 * 
	 */
	public OverridesAddPanel() {
		initWidget(uiBinder.createAndBindUi(this));
		
		security = NeptuneApplication.getApplication().getSecurity();
		
		btnCancel.addStyleDependentName(StyleNames.CAUTION_BUTTON_STYLE);
		if (security.isUserInRole(Permissions.EDIT)) {
			btnSaveAllOverrides.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
			btnAddMore.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
			btnDelete.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);	
		}
		else {
			btnAddMore.setVisible(false);
			btnSaveAllOverrides.setVisible(false);
			btnDelete.setVisible(false);
		}
	}

	@UiHandler("btnAddMore")
	public void onClickAddMore(ClickEvent event) {
		numRows++;
		final OverrideRow blankOverrideRow = new OverrideRow();
		overrideRowsPanel.addOverrideRow(blankOverrideRow);
		overrideRowsPanel.addOverrideRowToTable(numRows, blankOverrideRow);

		Scheduler.get().scheduleDeferred(new ScheduledCommand() {
	        public void execute () {
	        	blankOverrideRow.setFocus(true);
	        }
	   });
}
	
	@UiHandler("btnSaveAllOverrides")
	public void onClickSaveAllOverrides(ClickEvent event) {
		overrideRowsPanel.saveAllOverrides(uiMSO);
	}
	
	@UiHandler("btnCancel")
	public void onClickCancel(ClickEvent event) {
		MSOOverridesTab.getEventBus().fireEvent(new CancelAddEvent());		
	}
	
	@UiHandler("btnDelete")
	public void onClickDelete(ClickEvent event) {
		overrideRowsPanel.removeSelected();
	}
	
	public UIMSO getUiMSO() {
		return uiMSO;
	}

	public void setUiMSO(UIMSO uiMSO) {
		this.uiMSO = uiMSO;
	}
	
	public void refresh() {
		if (uiMSO != null) {
			numRows = 0;
			
			List<UIMSOOverride> uiMSOOverrides = new ArrayList<UIMSOOverride>();
			UIMSOOverride uiMSOOverride = new UIMSOOverride();
			uiMSOOverrides.add(uiMSOOverride);
			
			overrideRowsPanel.setUIMSOOverrides(uiMSOOverrides);
			Scheduler.get().scheduleDeferred(new ScheduledCommand() {
				public void execute() {
					overrideRowsPanel.resetFocus(true);
				}
			});
			numRows++;
		}
	}
	
	public void removeSelected() {
		overrideRowsPanel.removeSelected();
	}

	public void updateSize(int offsetWidth, int offsetHeight) {
		int height = Window.getClientHeight() - offsetHeight - buttonsPanel.getOffsetHeight();
		scrollPanel.setHeight(height + "px");
	}

}
