/**
 * File Name	:	OverridesLisPanel.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Dec 25, 2011 6:35:14 AM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import com.ericsson.cms.sites.ui.client.msooverrides.list.PaginatedOverridesListPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class OverridesListPanel extends Composite {

	interface MyUiBinder extends UiBinder<Widget, OverridesListPanel> {}
	private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);

	@UiField
	PaginatedOverridesListPanel paginatedOverridesListPanel;
	
	private UIMSO uiMSO;
	
	/**
	 * 
	 */
	public OverridesListPanel() {		
		initWidget(uiBinder.createAndBindUi(this));
	}

	public UIMSO getUiMSO() {
		return uiMSO;
	}

	public void setUiMSO(UIMSO uiMSO) {
		this.uiMSO = uiMSO;
		this.paginatedOverridesListPanel.setUiMSO(uiMSO);
	}
	
	public void refresh() {
		if (uiMSO != null) {
			paginatedOverridesListPanel.refresh("Refresh called for UIMSO : " + uiMSO);
		}
	}

	public void updateSize(int offsetWidth, int offsetHeight) {
		paginatedOverridesListPanel.updateSize(offsetWidth, offsetHeight);
	}
}
