/**
 * File Name	:	OverridesLisPanel.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Dec 25, 2011 6:35:14 AM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides;

import java.util.List;

import com.ericsson.cms.sites.ui.client.Permissions;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.msooverrides.events.CancelMSOAddEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.EmptyMSONameEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSOAddedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSODeletedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSONameAlreadyUsedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.MSORenamedEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.NeptuneFailureEvent;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SingleSelectionModel;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.MSOsPanel;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DialogBoxContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class ShowAddDeleteMSOsPanel extends Composite {

	interface MyUiBinder extends UiBinder<Widget, ShowAddDeleteMSOsPanel> {}
	private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);

	@UiField
	MSOsPanel msosPanel;
			
	@UiField
	Button btnAdd;
	
	@UiField
	Button btnDelete;

	@UiField
	Button btnRename;
	
	@UiField
	HorizontalPanel hpAddMSO;
	
	@UiField
	TextBox txtMSO;
	
	@UiField
	Button btnSave;
	
	@UiField
	Button btnCancel;
	
	private UISite uiSite;
	
	private boolean addingMSO;
	
	private boolean renamingMSO;

	private IUIMSOOverridesServiceAsync uiMSOOverridesService = GWT.create(IUIMSOOverridesService.class);
	
	private SitesConstants constants = GWT.create(SitesConstants.class); 
	private SitesMessages sitesMessages = GWT.create(SitesMessages.class);
	
	private final BusyIndicator busyIndicator = new BusyIndicator();

	private NeptuneSecurity security;

	/**
	 * 
	 */
	public ShowAddDeleteMSOsPanel() {
		initWidget(uiBinder.createAndBindUi(this));

		security = NeptuneApplication.getApplication().getSecurity();

		if (security.isUserInRole(Permissions.EDIT)) {
			btnAdd.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
			btnRename.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
			btnDelete.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
			btnSave.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
			btnCancel.addStyleDependentName(StyleNames.CAUTION_BUTTON_STYLE);
		}
		else {
			btnAdd.setVisible(false);
			btnDelete.setVisible(false);
			btnRename.setVisible(false);
		}
		
	}
	
	public void setMSOs(List<UIMSO> uiMSOs) {
		msosPanel.setMSOs(uiMSOs);
	}

	@UiHandler("btnAdd")
	public void onClickAdd(ClickEvent event) {
		txtMSO.setText(null);
		showAddPanel();
		addingMSO = true;
		renamingMSO = false;
		txtMSO.setFocus(true);
	}
	
	@SuppressWarnings("unchecked")
	@UiHandler("btnDelete")
	public void onClickDelete(ClickEvent event) {
		if (!msosPanel.isEmpty()) {
			SingleSelectionModel<UIMSO> selectionModel = (SingleSelectionModel<UIMSO>) msosPanel
					.getSelectionModel();
			UIMSO selectedUIMSO = selectionModel.getSelectedObject();
			if (selectedUIMSO != null) {
				confirm(constants.confirmDeleteSelectedMSO(), new Command() {

					@Override
					public void execute() {
						deleteSelectedMSO();
					}

				}, null);
			}
		}
	}

	@SuppressWarnings("unchecked")
	@UiHandler("btnRename")
	public void onClickRename(ClickEvent event) {
		SingleSelectionModel<UIMSO> selectionModel =  (SingleSelectionModel<UIMSO>) msosPanel.getSelectionModel();
		UIMSO selectedUIMSO = selectionModel.getSelectedObject();
		if (selectedUIMSO != null) {
			txtMSO.setText(selectedUIMSO.getMsoName());
			showAddPanel();
			addingMSO = false;
			renamingMSO = true;
			txtMSO.setFocus(true);
		}
	}

	@UiHandler("btnSave")
	public void onClickSave(ClickEvent event) {
		// First check if this mso name is already used.
		
		final int siteId = uiSite.getId();
		final String msoName = txtMSO.getText();
		
		
		if ((msoName != null) && !msoName.trim().isEmpty()) {
			showBusyIndicator();
			uiMSOOverridesService.isMSONameAlreadyUsed(siteId, msoName,
					new NeptuneAsyncCallback<Boolean>() {

						@Override
						public void onNeptuneFailure(Throwable caught) {
							String failureMessage = sitesMessages
									.errorCheckingMsoNameAlreadyUsed(caught
											.getLocalizedMessage());
							MSOOverridesTab.getEventBus().fireEvent(
									new NeptuneFailureEvent(failureMessage));
							hideBusyIndicator();
						}

						@SuppressWarnings("unchecked")
						@Override
						public void onNeptuneSuccess(Boolean result) {
							if (result) {
								MSOOverridesTab.getEventBus().fireEvent(
										new MSONameAlreadyUsedEvent(msoName));
							} else {
								if (addingMSO) {
									UIMSO uiMSO = new UIMSO();
									uiMSO.setMsoName(msoName);
									saveMSO(siteId, uiMSO);
								} else if (renamingMSO) {
									SingleSelectionModel<UIMSO> selectionModel = (SingleSelectionModel<UIMSO>) msosPanel
											.getSelectionModel();
									UIMSO selectedUIMSO = selectionModel
											.getSelectedObject();
									selectedUIMSO.setMsoName(msoName);
									saveMSO(siteId, selectedUIMSO);
								}
							}
							hideBusyIndicator();
						}

					});
		}
		else {
			MSOOverridesTab.getEventBus().fireEvent(
					new EmptyMSONameEvent());
		}
	}
	
	@UiHandler("btnCancel")
	public void onClickCancel(ClickEvent event) {
		hideAddPanel();
		MSOOverridesTab.getEventBus().fireEvent(new CancelMSOAddEvent());
	}
	
	public void saveMSO(final int siteId, final UIMSO uiMSO) {
		hideAddPanel();
		showBusyIndicator();
		uiMSOOverridesService.saveMSO(siteId, uiMSO, new NeptuneAsyncCallback<UIMSO>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				String failureMessage = sitesMessages.errorSavingMSO(siteId, caught.getLocalizedMessage());
				MSOOverridesTab.getEventBus().fireEvent(new NeptuneFailureEvent(failureMessage));
				hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(UIMSO result) {
				if (addingMSO) {
					MSOOverridesTab.getEventBus().fireEvent(
							new MSOAddedEvent(result));
					addingMSO = false;
				}
				else if (renamingMSO) {
					MSOOverridesTab.getEventBus().fireEvent(
							new MSORenamedEvent(result));
					renamingMSO = false;
				}
				hideBusyIndicator();
			}
			
		});
	}

	public UISite getUiSite() {
		return uiSite;
	}

	public void setUiSite(UISite uiSite) {
		this.uiSite = uiSite;
	}
	
	public void setSelected(UIMSO uiMSO) {
		msosPanel.setSelected(uiMSO, true);
	}

	public HandlerManager getEventBus() {
		return msosPanel.getEventBus();
	}

	public void setEventBus(HandlerManager eventBus) {
		msosPanel.setEventBus(eventBus);
	}

	private void showAddPanel() {
		hpAddMSO.setVisible(true);
	}
	
	private void hideAddPanel() {
		hpAddMSO.setVisible(false);
	}
	
	private void showBusyIndicator() {
    	busyIndicator.center();
    }

    private void hideBusyIndicator() {
    	busyIndicator.hide();
    }
	
	private void confirm(String questionText, final Command yesCommand,
			final Command noCommand) {
		final DialogBoxContainer dialogBox = new DialogBoxContainer(false, true);
		dialogBox.setText(questionText);

		// yes button
		ButtonWidget yesButton = new ButtonWidget(constants.buttonLabelYes());
		yesButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		yesButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				dialogBox.hide();
				if (yesCommand != null)
					yesCommand.execute();
			}
		});

		// no button
		ButtonWidget noButton = new ButtonWidget(constants.buttonLabelNo());
		noButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		noButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				dialogBox.hide();
				if (noCommand != null)
					noCommand.execute();
			}
		});

		// panel which contains the buttons
		HorizontalContainer buttonPanel = new HorizontalContainer();
		dialogBox.setWidget(buttonPanel);
		buttonPanel.add(yesButton);
		buttonPanel.setCellHorizontalAlignment(yesButton,
				HorizontalPanel.ALIGN_RIGHT);
		buttonPanel.add(noButton);
		buttonPanel.setCellHorizontalAlignment(noButton,
				HorizontalPanel.ALIGN_LEFT);

		dialogBox.center();
		dialogBox.show();
	}
	
	@SuppressWarnings("unchecked")
	private void deleteSelectedMSO() {
		SingleSelectionModel<UIMSO> selectionModel = (SingleSelectionModel<UIMSO>) msosPanel.getSelectionModel();
		final UIMSO selectedUIMSO = selectionModel.getSelectedObject();
		if (selectedUIMSO != null) {
			showBusyIndicator();
			uiMSOOverridesService.deleteMSO(selectedUIMSO.getMsoId(),
					new NeptuneAsyncCallback<Void>() {

						@Override
						public void onNeptuneFailure(Throwable caught) {
							String failureMessage = null;
							failureMessage = sitesMessages
									.errorDeletingMSO(
											selectedUIMSO.getMsoName(),
											caught.getLocalizedMessage());
							MSOOverridesTab.getEventBus().fireEvent(
									new NeptuneFailureEvent(failureMessage));
							hideBusyIndicator();
						}

						@Override
						public void onNeptuneSuccess(Void result) {
							MSOOverridesTab.getEventBus().fireEvent(
									new MSODeletedEvent());
							hideBusyIndicator();
						}

					});
		}
	}
}
