/**
 * File Name	:	DeleteOverridesEvent.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jan 2, 2012 10:01:30 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides.events;

import java.util.Collection;

import com.google.gwt.event.shared.GwtEvent;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class DeleteOverridesEvent extends GwtEvent<DeleteOverridesEventHandler> {

	public static final GwtEvent.Type<DeleteOverridesEventHandler> TYPE = 
			new GwtEvent.Type<DeleteOverridesEventHandler>();
	
	private final Collection<Long> overrideIds;
	
	public DeleteOverridesEvent(Collection<Long> overrideIds) {
		super();
		this.overrideIds = overrideIds;
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<DeleteOverridesEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(DeleteOverridesEventHandler handler) {
		handler.deleteOverrides(this);
	}

	public Collection<Long> getOverrideIds() {
		return overrideIds;
	}

}
