/**
 * File Name	:	MSOAddedEvent.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jan 2, 2012 8:59:39 AM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides.events;

import com.google.gwt.event.shared.GwtEvent;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class MSOAddedEvent extends GwtEvent<MSOAddedEventHandler> {
	public static final GwtEvent.Type<MSOAddedEventHandler> TYPE =
		      new GwtEvent.Type<MSOAddedEventHandler>();
	
	private final UIMSO uiMSO;

	public MSOAddedEvent(UIMSO uiMSO) {
		super();
		this.uiMSO = uiMSO;
	}
	
	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<MSOAddedEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(MSOAddedEventHandler handler) {
		handler.msoAdded(this);
		
	}

	public UIMSO getUiMSO() {
		return uiMSO;
	}
	
}
