/**
 * File Name	:	MSONameAlreadyUsedEvent.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jan 2, 2012 8:59:39 AM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides.events;

import com.google.gwt.event.shared.GwtEvent;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class MSONameAlreadyUsedEvent extends GwtEvent<MSONameAlreadyUsedEventHandler> {
	public static final GwtEvent.Type<MSONameAlreadyUsedEventHandler> TYPE =
		      new GwtEvent.Type<MSONameAlreadyUsedEventHandler>();
	
	private final String msoName;

	public MSONameAlreadyUsedEvent(String msoName) {
		super();
		this.msoName = msoName;
	}
	
	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<MSONameAlreadyUsedEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(MSONameAlreadyUsedEventHandler handler) {
		handler.msoNameAlreadyUsed(this);
		
	}

	/**
	 * @return the msoName
	 */
	public String getMsoName() {
		return msoName;
	}
	
}
