/**
 * File Name	:	NeptuneFailureEvent.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jan 2, 2012 8:59:39 AM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides.events;

import com.google.gwt.event.shared.GwtEvent;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class NeptuneFailureEvent extends GwtEvent<NeptuneFailureEventHandler> {
	public static final GwtEvent.Type<NeptuneFailureEventHandler> TYPE =
		      new GwtEvent.Type<NeptuneFailureEventHandler>();
	
	private final String failureMessage;

	public NeptuneFailureEvent(String failureMessage) {
		super();
		this.failureMessage = failureMessage;
	}
	
	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<NeptuneFailureEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(NeptuneFailureEventHandler handler) {
		handler.neptuneFailure(this);
		
	}

	public String getFailureMessage() {
		return failureMessage;
	}
	
}
