/**
 * File Name	:	RemoveOverridesEvent.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jan 2, 2012 10:01:30 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides.events;

import java.util.List;

import com.ericsson.cms.sites.ui.client.msooverrides.OverrideRow;
import com.google.gwt.event.shared.GwtEvent;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class RemoveOverridesEvent extends GwtEvent<RemoveOverridesEventHandler> {

	public static final GwtEvent.Type<RemoveOverridesEventHandler> TYPE = 
			new GwtEvent.Type<RemoveOverridesEventHandler>();
	
	private final List<OverrideRow> removedOverrideRows;
	
	public RemoveOverridesEvent(List<OverrideRow> removedOverrideRows) {
		this.removedOverrideRows = removedOverrideRows;
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<RemoveOverridesEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(RemoveOverridesEventHandler handler) {
		handler.removeOverrides(this);
	}

	public List<OverrideRow> getRemovedOverrideRows() {
		return removedOverrideRows;
	}
}
