/**
 * File Name	:	MetadataFieldView.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jan 6, 2012 7:42:14 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides.list;

import com.ericsson.cms.sites.ui.client.msooverrides.MetadataFieldWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.ViewBase;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class MetadataFieldView extends ViewBase<String> {

	protected MetadataFieldWidget metadataFieldWidget;
	
	/**
	 * @param value
	 */
	public MetadataFieldView(String value, boolean readOnly) {
		super(value);
		metadataFieldWidget.setEnabled(!readOnly);
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View#getWidget()
	 */
	@Override
	public MetadataFieldWidget getWidget() {
		return metadataFieldWidget;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View#release()
	 */
	@Override
	public void release() {
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.ViewBase#getViewValue()
	 */
	@Override
	protected String getViewValue() {
		return metadataFieldWidget.getValue();
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.ViewBase#setViewValue(java.lang.Object)
	 */
	@Override
	protected void setViewValue(String value) {
		metadataFieldWidget.setValue(value);
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.ViewBase#preInitialValueSet()
	 */
	@Override
	protected void preInitialValueSet() {
		metadataFieldWidget = new MetadataFieldWidget();
	}

}
