/**
 * File Name	:	PaginatedOverridesListDataProvider.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jan 5, 2012 6:35:46 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.sites.ui.client.Permissions;
import com.ericsson.cms.sites.ui.client.entities.msooverrides.UIMSOOverridesRequest;
import com.ericsson.cms.sites.ui.client.entities.msooverrides.UIMSOOverridesResponse;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesService;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesServiceAsync;
import com.ericsson.cms.sites.ui.client.msooverrides.MetadataFieldWidget;
import com.ericsson.cms.sites.ui.client.msooverrides.OverrideRow;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSOOverride;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class PaginatedOverridesListDataProvider implements
		DataProvider<Long, UIMSOOverrideRecord> {

    // column names
    private static final String FIELD_COLUMN = "fieldDisplayName";
    private static final String SEARCH_VALUE_COLUMN = "searchValue";
    private static final String REPLACEMENT_VALUE_COLUMN = "replacementValue";

    private static final String STYLE_FIELD_COLUMN = "msooverridesList-field-column";
    private static final String STYLE_SEARCH_VALUE_COLUMN = "msooverridesList-searchValue-column";
    private static final String STYLE_REPLACEMENT_VALUE_COLUMN = "msooverridesList-replacementValue-column";


    private PaginatedOverridesListPanel view;

	private IUIMSOOverridesServiceAsync uiMSOOverridesService = GWT.create(IUIMSOOverridesService.class);
	private SitesConstants constants = GWT.create(SitesConstants.class);

	private List<Column<?, UIMSOOverrideRecord>> columns;
	private ColumnBase<String, UIMSOOverrideRecord> fieldColumn;
	private ColumnBase<String, UIMSOOverrideRecord> searchValueColumn;
	private ColumnBase<String, UIMSOOverrideRecord> replacementValueColumn;
	
	private PageFeatureImpl pageFeature;
	private SortFeatureImpl<Long, UIMSOOverrideRecord> sortFeature;
	
	private NeptuneSecurity security;
				
	/**
	 * 
	 */
	public PaginatedOverridesListDataProvider(final PaginatedOverridesListPanel view) {
		this.view = view;
		
		columns = new ArrayList<Column<?, UIMSOOverrideRecord>>();
		
		security = NeptuneApplication.getApplication().getSecurity();

		final boolean editable = security.isUserInRole(Permissions.EDIT);
						
		fieldColumn = new ColumnBase<String, UIMSOOverrideRecord>(FIELD_COLUMN, constants.columnHeadingField()) {
			public View<String> getView(UIMSOOverrideRecord record) {
				MetadataFieldView metadataFieldView = new MetadataFieldView(record.getUiMSOOverride().getFieldXPath(), !editable);
				MetadataFieldWidget metadataField = metadataFieldView.getWidget();
				metadataField.setWidth("98%");
				Map<Long, OverrideRow> overrideRowsMap = view.getOverrideRowsMap();
				OverrideRow overrideRow = overrideRowsMap.get(record.getKey());
				if (overrideRow == null) {
					overrideRow = new OverrideRow();
					overrideRow.setOverrideId(record.getKey());
					overrideRowsMap.put(record.getKey(), overrideRow);
				}
				overrideRow.setMfwFieldXPath(metadataField);
				return metadataFieldView;
			}
		};
		fieldColumn.setCellStyle(STYLE_FIELD_COLUMN);
		columns.add(fieldColumn);
		
		searchValueColumn = new ColumnBase<String, UIMSOOverrideRecord>(SEARCH_VALUE_COLUMN, constants.columnHeadingSearchValue()) {
			public View<String> getView(UIMSOOverrideRecord record) {
				TextBoxView textBoxStringView = new TextBoxView(record.getUiMSOOverride().getSearchValue(), !editable);
				TextBoxWidget txtSearchValue = textBoxStringView.getTextBoxWidget();
				txtSearchValue.setWidth("98%");
				Map<Long, OverrideRow> overrideRowsMap = view.getOverrideRowsMap();
				OverrideRow overrideRow = overrideRowsMap.get(record.getKey());
				overrideRow.setTxtSearchValue(txtSearchValue);
				return textBoxStringView;
			}
		};
		searchValueColumn.setCellStyle(STYLE_SEARCH_VALUE_COLUMN);
		columns.add(searchValueColumn);

		replacementValueColumn = new ColumnBase<String, UIMSOOverrideRecord>(REPLACEMENT_VALUE_COLUMN, constants.columnHeadingReplacementValue()) {
			public View<String> getView(UIMSOOverrideRecord record) {
				TextBoxView textBoxStringView = new TextBoxView(record.getUiMSOOverride().getReplacementValue(), !editable);
				TextBoxWidget txtReplacementValue = textBoxStringView.getTextBoxWidget();
				txtReplacementValue.setWidth("98%");
				Map<Long, OverrideRow> overrideRowsMap = view.getOverrideRowsMap();
				OverrideRow overrideRow = overrideRowsMap.get(record.getKey());
				overrideRow.setTxtReplacementValue(txtReplacementValue);
				return textBoxStringView;
			}
		};
		replacementValueColumn.setCellStyle(STYLE_REPLACEMENT_VALUE_COLUMN);
		columns.add(replacementValueColumn);

	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#initialize(com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void initialize(AsyncCallback<Void> callback) {
		callback.onSuccess(null);
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#getColumns()
	 */
	@Override
	public List<Column<?, UIMSOOverrideRecord>> getColumns() {
		return columns;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#getRecords(com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getRecords(final AsyncCallback<List<UIMSOOverrideRecord>> callback) {
		UIMSO uiMSO = view.getUiMSO();
		if (uiMSO != null) {
			view.handleGetRecordsRequest();
			
			int msoId = uiMSO.getMsoId();
			final UIMSOOverridesRequest uiMSOOverridesRequest = new UIMSOOverridesRequest();
			uiMSOOverridesRequest.setMsoId(msoId);
			if (pageFeature != null) {
				uiMSOOverridesRequest.setStartIndex((pageFeature
						.getPageNumber() - 1) * (pageFeature.getPageSize()));
				uiMSOOverridesRequest.setNumRecords(pageFeature.getPageSize());
			}
			if (sortFeature != null) {
				uiMSOOverridesRequest.setSortColumnName(sortFeature
						.getSortColumnName());
				uiMSOOverridesRequest.setAscending(sortFeature.isAscending());
			}
		
			uiMSOOverridesService.getMSOOverrides(uiMSOOverridesRequest, new NeptuneAsyncCallback<UIMSOOverridesResponse>() {

				@Override
				public void onNeptuneFailure(Throwable caught) {
					pageFeature.setRecordCount(-1);
	                callback.onFailure(caught);
	                view.handleGetRecordsFailureResponse(caught);
				}

				@Override
				public void onNeptuneSuccess(UIMSOOverridesResponse result) {
					List<UIMSOOverrideRecord> records = null;
					if (result != null) {
						pageFeature.setRecordCount(result.getCount());
						records = getRecords(uiMSOOverridesRequest, result.getUiMSOOverrides());
					}
					callback.onSuccess(records);
					view.handleGetRecordsSuccessResponse(records);
				}
				
			});
			
		}
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#getRecord(java.lang.Object, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getRecord(Long key, AsyncCallback<UIMSOOverrideRecord> callback) {
		throw new UnsupportedOperationException();
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#isRecordCountEnabled()
	 */
	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#isCheckboxEnabled()
	 */
	@Override
	public boolean isCheckboxEnabled() {
		return true;
	}
		
	public void setPageFeature(PageFeatureImpl pageFeature) {
		this.pageFeature = pageFeature;
	}
	
	public ColumnBase<String, UIMSOOverrideRecord> getDefaultSortColumn() {
        return fieldColumn;
    }

	public SortOrder getDefaultSortOrder() {
		return SortOrder.ASCENDING;
	}
	
	public List<Column<?, UIMSOOverrideRecord>> getSortableColumns() {
		List<Column<?, UIMSOOverrideRecord>> sortableColumns = new ArrayList<Column<?, UIMSOOverrideRecord>>();
		
		sortableColumns.add(fieldColumn);
		sortableColumns.add(searchValueColumn);
		sortableColumns.add(replacementValueColumn);
		
		return sortableColumns;
	}
	
	public void setSortFeature(SortFeatureImpl<Long, UIMSOOverrideRecord> sortFeature) {
		this.sortFeature = sortFeature;
	}

	/**
	 * 
	 * @param uiMSOOverridesRequest
	 * @param uiMSOOverrides
	 * @return
	 */
	private List<UIMSOOverrideRecord> getRecords(UIMSOOverridesRequest uiMSOOverridesRequest, List<UIMSOOverride> uiMSOOverrides) {
		List<UIMSOOverrideRecord> records = null;
		
		if ((uiMSOOverridesRequest != null) && (uiMSOOverrides != null)) {
			records = new ArrayList<UIMSOOverrideRecord>();
			
			if (uiMSOOverrides.size() > 0) {
				for (UIMSOOverride uiMSOOverride : uiMSOOverrides) {
					UIMSOOverrideRecord record = new UIMSOOverrideRecord(
							uiMSOOverride);
					records.add(record);
				}
			}
		}
		return records;
	}

}
